/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.mutation;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.DoubleStream;
import org.evosuite.ga.operators.mutation.MutationDistribution;
import org.evosuite.utils.Randomness;

public class BinomialMutation
extends MutationDistribution {
    private static final long serialVersionUID = 9013772318848850918L;
    private Set<Integer> bitsToBeModified;

    public BinomialMutation(int sizeOfDistribution) {
        int numBits = this.howManyBits(sizeOfDistribution, 1.0 / (double)sizeOfDistribution);
        this.bitsToBeModified = new LinkedHashSet<Integer>();
        while (this.bitsToBeModified.size() < numBits) {
            this.bitsToBeModified.add(Randomness.nextInt(0, sizeOfDistribution));
        }
    }

    @Override
    public boolean toMutate(int index) {
        return this.bitsToBeModified.contains(index);
    }

    private int howManyBits(int numTrials, double probability) {
        return (int)DoubleStream.generate(Randomness::nextDouble).limit(numTrials).filter(d -> d <= probability).count();
    }
}

