/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.ranking;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.comparators.DominanceComparator;
import org.evosuite.ga.operators.ranking.RankingFunction;

public class FastNonDominatedSorting<T extends Chromosome<T>>
implements RankingFunction<T> {
    private static final long serialVersionUID = -5649595833522859850L;
    private List<T>[] ranking_;
    private final Map<FitnessFunction<T>, T> newCoveredGoals = new LinkedHashMap<FitnessFunction<T>, T>();

    @Override
    public void computeRankingAssignment(List<T> solutions, Set<? extends FitnessFunction<T>> uncovered_goals) {
        List<T>[] fronts = this.getNextNonDominatedFronts(solutions, uncovered_goals);
        this.ranking_ = new ArrayList[fronts.length];
        System.arraycopy(fronts, 0, this.ranking_, 0, fronts.length);
    }

    private List<T>[] getNextNonDominatedFronts(List<T> solutionSet, Set<? extends FitnessFunction<T>> uncovered_goals) {
        int p;
        DominanceComparator<Chromosome> criterion_ = new DominanceComparator<Chromosome>(uncovered_goals);
        int[] dominateMe = new int[solutionSet.size()];
        List[] iDominate = new List[solutionSet.size()];
        List[] front = new List[solutionSet.size() + 1];
        for (int i = 0; i < front.length; ++i) {
            front[i] = new LinkedList();
        }
        for (Chromosome solution : solutionSet) {
            solution.setDistance(Double.MAX_VALUE);
        }
        for (p = 0; p < solutionSet.size(); ++p) {
            iDominate[p] = new LinkedList();
            dominateMe[p] = 0;
        }
        for (p = 0; p < solutionSet.size() - 1; ++p) {
            for (int q = p + 1; q < solutionSet.size(); ++q) {
                int flagDominate = criterion_.compare((Chromosome)solutionSet.get(p), (Chromosome)solutionSet.get(q));
                if (flagDominate == -1) {
                    iDominate[p].add(q);
                    int n = q;
                    dominateMe[n] = dominateMe[n] + 1;
                    continue;
                }
                if (flagDominate != 1) continue;
                iDominate[q].add(p);
                int n = p;
                dominateMe[n] = dominateMe[n] + 1;
            }
        }
        for (p = 0; p < solutionSet.size(); ++p) {
            if (dominateMe[p] != 0) continue;
            front[0].add(p);
            ((Chromosome)solutionSet.get(p)).setRank(1);
        }
        int i = 0;
        while (front[i].size() != 0) {
            Iterator it1 = front[++i - 1].iterator();
            while (it1.hasNext()) {
                Iterator it2 = iDominate[(Integer)it1.next()].iterator();
                while (it2.hasNext()) {
                    int index;
                    int n = index = ((Integer)it2.next()).intValue();
                    dominateMe[n] = dominateMe[n] - 1;
                    if (dominateMe[index] != 0) continue;
                    front[i].add(index);
                    ((Chromosome)solutionSet.get(index)).setRank(i + 1);
                }
            }
        }
        ArrayList[] fronts = new ArrayList[i];
        for (int j = 0; j < i; ++j) {
            fronts[j] = new ArrayList();
            Iterator it1 = front[j].iterator();
            while (it1.hasNext()) {
                fronts[j].add(solutionSet.get((Integer)it1.next()));
            }
        }
        return fronts;
    }

    @Override
    public List<T> getSubfront(int rank) {
        return this.ranking_[rank];
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.ranking_.length;
    }
}

