/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.selection;

import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.comparators.RankAndCrowdingDistanceComparator;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.utils.Randomness;

public class BinaryTournamentSelectionCrowdedComparison<T extends Chromosome<T>>
extends SelectionFunction<T> {
    private static final long serialVersionUID = -6887165634607218631L;
    private int index = 0;
    private int[] indexes;
    private final RankAndCrowdingDistanceComparator<T> comparator;

    public BinaryTournamentSelectionCrowdedComparison() {
        this.comparator = new RankAndCrowdingDistanceComparator(this.maximize);
    }

    public BinaryTournamentSelectionCrowdedComparison(boolean isToMaximize) {
        this.comparator = new RankAndCrowdingDistanceComparator(isToMaximize);
    }

    public BinaryTournamentSelectionCrowdedComparison(BinaryTournamentSelectionCrowdedComparison<?> other) {
        this.index = other.index;
        this.indexes = other.indexes;
        this.comparator = new RankAndCrowdingDistanceComparator(other.comparator);
    }

    @Override
    public int getIndex(List<T> population) {
        if (this.index == 0) {
            this.indexes = this.intPermutation(population.size());
        }
        int index1 = this.index;
        Chromosome p1 = (Chromosome)population.get(this.indexes[index1]);
        int index2 = this.index + 1;
        Chromosome p2 = (Chromosome)population.get(this.indexes[index2]);
        this.index = (this.index + 2) % population.size();
        int flag = this.comparator.compare(p1, p2);
        if (flag < 0) {
            return index1;
        }
        if (flag > 0) {
            return index2;
        }
        return index1;
    }

    private int[] intPermutation(int length) {
        int i;
        int[] aux = new int[length];
        int[] result = new int[length];
        for (i = 0; i < length; ++i) {
            result[i] = i;
            aux[i] = Randomness.nextInt(0, length - 1);
        }
        for (i = 0; i < length; ++i) {
            for (int j = i + 1; j < length; ++j) {
                if (aux[i] <= aux[j]) continue;
                int tmp = aux[i];
                aux[i] = aux[j];
                aux[j] = tmp;
                tmp = result[i];
                result[i] = result[j];
                result[j] = tmp;
            }
        }
        return result;
    }

    @Override
    public void setMaximize(boolean max) {
        super.setMaximize(max);
        this.comparator.setMaximize(max);
    }
}

