/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxFitnessEvaluationsStoppingCondition<T extends Chromosome<T>>
extends StoppingConditionImpl<T> {
    private static final Logger logger = LoggerFactory.getLogger(MaxFitnessEvaluationsStoppingCondition.class);
    private static final long serialVersionUID = 208241490252275613L;
    protected long maxEvaluations;
    protected static long currentEvaluation = 0L;

    public MaxFitnessEvaluationsStoppingCondition() {
        this.maxEvaluations = Properties.SEARCH_BUDGET;
    }

    public MaxFitnessEvaluationsStoppingCondition(MaxFitnessEvaluationsStoppingCondition<?> that) {
        this.maxEvaluations = that.maxEvaluations;
    }

    @Override
    public MaxFitnessEvaluationsStoppingCondition<T> clone() {
        return new MaxFitnessEvaluationsStoppingCondition<T>(this);
    }

    @Override
    public boolean isFinished() {
        logger.info("Current number of fitness_evaluations: " + currentEvaluation);
        return currentEvaluation >= this.maxEvaluations;
    }

    @Override
    public void fitnessEvaluation(T individual) {
        ++currentEvaluation;
    }

    public static long getNumFitnessEvaluations() {
        return currentEvaluation;
    }

    @Override
    public void reset() {
        currentEvaluation = 0L;
    }

    @Override
    public void setLimit(long limit) {
        this.maxEvaluations = limit;
    }

    @Override
    public long getLimit() {
        return this.maxEvaluations;
    }

    @Override
    public long getCurrentValue() {
        return currentEvaluation;
    }

    @Override
    public void forceCurrentValue(long value) {
        currentEvaluation = value;
    }
}

