/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;

public class MaxTimeStoppingCondition<T extends Chromosome<T>>
extends StoppingConditionImpl<T> {
    private static final long serialVersionUID = -4524853279562896768L;
    protected long maxSeconds;
    protected long startTime;

    public MaxTimeStoppingCondition() {
        this.maxSeconds = Properties.SEARCH_BUDGET;
    }

    public MaxTimeStoppingCondition(MaxTimeStoppingCondition<?> that) {
        this.startTime = that.startTime;
        this.maxSeconds = that.maxSeconds;
    }

    @Override
    public MaxTimeStoppingCondition<T> clone() {
        return new MaxTimeStoppingCondition<T>(this);
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public boolean isFinished() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 1000L > this.maxSeconds;
    }

    @Override
    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void setLimit(long limit) {
        this.maxSeconds = limit;
    }

    @Override
    public long getLimit() {
        return this.maxSeconds;
    }

    @Override
    public long getCurrentValue() {
        long currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 1000L;
    }

    @Override
    public void forceCurrentValue(long value) {
        this.startTime = value;
    }
}

