/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import java.io.Serializable;
import java.text.NumberFormat;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;

public abstract class StoppingConditionImpl<T extends Chromosome<T>>
implements StoppingCondition<T>,
Serializable {
    private static final long serialVersionUID = -8221978873140881671L;

    public StoppingConditionImpl() {
        this.reset();
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void fitnessEvaluation(T chromosome) {
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void modification(T individual) {
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        String type = this.getType();
        type = type + " :";
        type = StringUtils.rightPad(type, 24);
        r.append(type);
        r.append(this.getValueString());
        if (this.isFinished()) {
            r.append(" Finished!");
        }
        return r.toString();
    }

    public String getType() {
        String type = this.getClass().toString();
        try {
            type = type.substring(type.lastIndexOf(".") + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type.endsWith("StoppingCondition")) {
            type = type.substring(0, type.length() - 17);
        }
        return type;
    }

    public String getValueString() {
        String value = NumberFormat.getIntegerInstance().format(this.getCurrentValue());
        value = StringUtils.leftPad(value, 12);
        String limit = NumberFormat.getIntegerInstance().format(this.getLimit());
        limit = StringUtils.rightPad(limit, 12);
        return value + " / " + limit;
    }

    @Override
    public abstract StoppingConditionImpl<T> clone();
}

