/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cdg;

import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.graphs.EvoSuiteGraph;
import org.evosuite.graphs.cdg.DominatorTree;
import org.evosuite.graphs.cfg.ActualControlFlowGraph;
import org.evosuite.graphs.cfg.BasicBlock;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.graphs.cfg.ControlFlowEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlDependenceGraph
extends EvoSuiteGraph<BasicBlock, ControlFlowEdge> {
    private static final Logger logger = LoggerFactory.getLogger(ControlDependenceGraph.class);
    private final ActualControlFlowGraph cfg;
    private final String className;
    private final String methodName;

    public ControlDependenceGraph(ActualControlFlowGraph cfg) {
        super(ControlFlowEdge.class);
        this.cfg = cfg;
        this.className = cfg.getClassName();
        this.methodName = cfg.getMethodName();
        this.computeGraph();
    }

    public boolean knowsInstruction(BytecodeInstruction ins) {
        return this.cfg.knowsInstruction(ins);
    }

    public int getControlDependenceDepth(ControlDependency dependence) {
        int min = Integer.MAX_VALUE;
        for (BasicBlock root : this.determineEntryPoints()) {
            int distance = this.getDistance(root, dependence.getBranch().getInstruction().getBasicBlock());
            if (distance >= min) continue;
            min = distance;
        }
        return min;
    }

    public Set<BasicBlock> getAlternativeBlocks(ControlDependency dependency) {
        LinkedHashSet<BasicBlock> blocks = new LinkedHashSet<BasicBlock>();
        Branch branch = dependency.getBranch();
        BasicBlock block = branch.getInstruction().getBasicBlock();
        for (ControlFlowEdge e : this.outgoingEdgesOf(block)) {
            if (e.getControlDependency() == null || e.getControlDependency().equals(dependency)) continue;
            BasicBlock next = (BasicBlock)this.getEdgeTarget(e);
            blocks.add(next);
            this.getReachableBasicBlocks(blocks, next);
        }
        return blocks;
    }

    private void getReachableBasicBlocks(Set<BasicBlock> blocks, BasicBlock start) {
        for (ControlFlowEdge e : this.outgoingEdgesOf(start)) {
            BasicBlock next = (BasicBlock)this.getEdgeTarget(e);
            if (blocks.contains(next)) continue;
            blocks.add(next);
            this.getReachableBasicBlocks(blocks, next);
        }
    }

    public Set<ControlDependency> getControlDependentBranches(BasicBlock insBlock) {
        if (insBlock == null) {
            throw new IllegalArgumentException("null not accepted");
        }
        if (!this.containsVertex(insBlock)) {
            throw new IllegalArgumentException("unknown block: " + insBlock.getName());
        }
        if (insBlock.hasControlDependenciesSet()) {
            return insBlock.getControlDependencies();
        }
        Set<ControlDependency> r = this.retrieveControlDependencies(insBlock, new LinkedHashSet<ControlFlowEdge>());
        return r;
    }

    private Set<ControlDependency> retrieveControlDependencies(BasicBlock insBlock, Set<ControlFlowEdge> handled) {
        LinkedHashSet<ControlDependency> r = new LinkedHashSet<ControlDependency>();
        for (ControlFlowEdge e : this.incomingEdgesOf(insBlock)) {
            if (handled.contains(e)) continue;
            handled.add(e);
            ControlDependency cd = e.getControlDependency();
            if (cd != null) {
                r.add(cd);
                continue;
            }
            BasicBlock in = (BasicBlock)this.getEdgeSource(e);
            if (in.equals(insBlock)) continue;
            r.addAll(this.retrieveControlDependencies(in, handled));
        }
        return r;
    }

    public Set<Integer> getControlDependentBranchIds(BasicBlock ins) {
        Set<ControlDependency> dependentBranches = this.getControlDependentBranches(ins);
        LinkedHashSet<Integer> r = new LinkedHashSet<Integer>();
        for (ControlDependency cd : dependentBranches) {
            if (cd == null) {
                throw new IllegalStateException("expect set returned by getControlDependentBranches() not to contain null");
            }
            r.add(cd.getBranch().getActualBranchId());
        }
        if (this.isRootDependent(ins)) {
            r.add(-1);
        }
        return r;
    }

    public boolean isDirectlyControlDependentOn(BytecodeInstruction ins, Branch b) {
        if (ins == null) {
            throw new IllegalArgumentException("null given");
        }
        BasicBlock insBlock = ins.getBasicBlock();
        return this.isDirectlyControlDependentOn(insBlock, b);
    }

    public boolean isDirectlyControlDependentOn(BasicBlock insBlock, Branch b) {
        Set incomming = this.incomingEdgesOf(insBlock);
        if (incomming.size() == 1) {
            for (ControlFlowEdge e : incomming) {
                if (e.hasControlDependency() || e.isExceptionEdge()) continue;
                return this.isDirectlyControlDependentOn((BasicBlock)this.getEdgeSource(e), b);
            }
        }
        boolean isRootDependent = this.isRootDependent(insBlock);
        if (b == null) {
            return isRootDependent;
        }
        if (isRootDependent && b != null) {
            return false;
        }
        for (ControlFlowEdge e : incomming) {
            Branch current = e.getBranchInstruction();
            if (e.isExceptionEdge()) {
                if (current == null) continue;
                throw new IllegalStateException("expect exception edges to have no BranchInstruction set");
            }
            if (current == null || !current.equals(b)) continue;
            return true;
        }
        return false;
    }

    public boolean isRootDependent(BytecodeInstruction ins) {
        return this.isRootDependent(ins.getBasicBlock());
    }

    public boolean isRootDependent(BasicBlock insBlock) {
        if (this.isAdjacentToEntryBlock(insBlock)) {
            return true;
        }
        for (ControlFlowEdge in : this.incomingEdgesOf(insBlock)) {
            BasicBlock inBlock;
            if (in.hasControlDependency() || (inBlock = (BasicBlock)this.getEdgeSource(in)).equals(insBlock) || !this.isRootDependent(inBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdjacentToEntryBlock(BasicBlock insBlock) {
        if (insBlock.isEntryBlock()) {
            return true;
        }
        Set<BasicBlock> parents = this.getParents(insBlock);
        for (BasicBlock parent : parents) {
            if (!parent.isEntryBlock()) continue;
            return true;
        }
        return false;
    }

    private void computeGraph() {
        this.createGraphNodes();
        this.computeControlDependence();
    }

    private void createGraphNodes() {
        this.addVertices(this.cfg);
        for (BasicBlock b : this.vertexSet()) {
            if (!b.isExitBlock() || this.graph.removeVertex(b)) continue;
            throw new IllegalStateException("internal error building up CDG");
        }
    }

    private void computeControlDependence() {
        ActualControlFlowGraph rcfg = this.cfg.computeReverseCFG();
        DominatorTree<BasicBlock> dt = new DominatorTree<BasicBlock>(rcfg);
        for (BasicBlock b : rcfg.vertexSet()) {
            if (b.isExitBlock()) continue;
            logger.debug("DFs for: " + b.getName());
            for (BasicBlock cd : dt.getDominatingFrontiers(b)) {
                ControlFlowEdge orig = (ControlFlowEdge)this.cfg.getEdge(cd, b);
                if (!cd.isEntryBlock() && orig == null) {
                    logger.debug("cd: " + cd.toString());
                    logger.debug("b: " + b.toString());
                    Set candidates = this.cfg.outgoingEdgesOf(cd);
                    if (candidates.size() < 2) {
                        throw new IllegalStateException("unexpected");
                    }
                    boolean leadToB = false;
                    boolean skip = false;
                    for (ControlFlowEdge e : candidates) {
                        if (!e.hasControlDependency()) {
                            skip = true;
                            break;
                        }
                        if (!this.cfg.leadsToNode(e, b)) continue;
                        if (leadToB) {
                            orig = null;
                        }
                        leadToB = true;
                        orig = e;
                    }
                    if (skip) continue;
                    if (!leadToB) {
                        throw new IllegalStateException("unexpected");
                    }
                }
                if (orig == null) {
                    logger.debug("orig still null!");
                }
                if (!this.addEdge(cd, b, new ControlFlowEdge(orig))) {
                    throw new IllegalStateException("internal error while adding CD edge");
                }
                logger.debug("  " + cd.getName());
            }
        }
    }

    @Override
    public String getName() {
        return this.methodName + "_CDG";
    }

    @Override
    protected String dotSubFolder() {
        return this.toFileString(this.className) + "/CDG/";
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

