/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.CFGFrame;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.FrameNode;
import org.evosuite.shaded.org.objectweb.asm.tree.IincInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LabelNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LineNumberNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.VarInsnNode;
import org.evosuite.shaded.org.objectweb.asm.util.Printer;

public abstract class ASMWrapper {
    protected AbstractInsnNode asmNode;
    protected CFGFrame frame;

    public AbstractInsnNode getASMNode() {
        return this.asmNode;
    }

    public String getInstructionType() {
        if (this.asmNode.getOpcode() >= 0 && this.asmNode.getOpcode() < Printer.OPCODES.length) {
            return Printer.OPCODES[this.asmNode.getOpcode()];
        }
        if (this.isLineNumber()) {
            return "LINE " + this.getLineNumber();
        }
        return this.getType();
    }

    public String getMethodCallDescriptor() {
        if (!this.isMethodCall()) {
            return null;
        }
        MethodInsnNode meth = (MethodInsnNode)this.asmNode;
        return meth.desc;
    }

    public String getType() {
        String type = "";
        if (this.asmNode.getType() >= 0 && this.asmNode.getType() < Printer.TYPES.length) {
            type = Printer.TYPES[this.asmNode.getType()];
        }
        return type;
    }

    public abstract int getInstructionId();

    public abstract String getMethodName();

    public abstract String getClassName();

    public abstract boolean isMethodCallOfField();

    public abstract String getFieldMethodCallName();

    public boolean isActualBranch() {
        return this.isBranch() || this.isSwitch();
    }

    public boolean isSwitch() {
        return this.isLookupSwitch() || this.isTableSwitch();
    }

    public boolean canReturnFromMethod() {
        return this.isReturn() || this.isThrow();
    }

    public boolean isReturn() {
        switch (this.asmNode.getOpcode()) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    public boolean isThrow() {
        return this.asmNode.getOpcode() == 191;
    }

    public boolean isTableSwitch() {
        return this.asmNode instanceof TableSwitchInsnNode;
    }

    public boolean isLookupSwitch() {
        return this.asmNode instanceof LookupSwitchInsnNode;
    }

    public boolean isBranchLabel() {
        return this.asmNode instanceof LabelNode && ((LabelNode)this.asmNode).getLabel().info instanceof Integer;
    }

    public boolean isJump() {
        return this.asmNode instanceof JumpInsnNode;
    }

    public boolean isInvokeStatic() {
        if (this.asmNode instanceof MethodInsnNode) {
            return this.asmNode.getOpcode() == 184;
        }
        return false;
    }

    public boolean isGoto() {
        if (this.asmNode instanceof JumpInsnNode) {
            return this.asmNode.getOpcode() == 167;
        }
        return false;
    }

    public boolean isBranch() {
        return this.isJump() && !this.isGoto();
    }

    public boolean isIfNull() {
        if (this.asmNode instanceof JumpInsnNode) {
            return this.asmNode.getOpcode() == 198;
        }
        return false;
    }

    public boolean isFrame() {
        return this.asmNode instanceof FrameNode;
    }

    public boolean isMethodCall() {
        return this.asmNode instanceof MethodInsnNode;
    }

    public String getCalledMethod() {
        if (!this.isMethodCall()) {
            return null;
        }
        MethodInsnNode meth = (MethodInsnNode)this.asmNode;
        return meth.name + meth.desc;
    }

    public String getCalledMethodName() {
        if (!this.isMethodCall()) {
            return null;
        }
        MethodInsnNode meth = (MethodInsnNode)this.asmNode;
        return meth.name;
    }

    public boolean isMethodCallForClass(String className) {
        if (this.isMethodCall()) {
            return this.getCalledMethodsClass().equals(className);
        }
        return false;
    }

    public String getCalledMethodsClass() {
        if (this.isMethodCall()) {
            MethodInsnNode mn = (MethodInsnNode)this.asmNode;
            return mn.owner.replaceAll("/", "\\.");
        }
        return null;
    }

    public int getCalledMethodsArgumentCount() {
        if (this.isMethodCall()) {
            MethodInsnNode mn = (MethodInsnNode)this.asmNode;
            Type[] argTypes = Type.getArgumentTypes(mn.desc);
            return argTypes.length;
        }
        return -1;
    }

    public boolean isLoadConstant() {
        return this.asmNode.getOpcode() == 18;
    }

    public boolean isConstant() {
        switch (this.asmNode.getOpcode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefUse() {
        return this.isDefinition() || this.isUse();
    }

    public boolean isFieldDU() {
        return this.isFieldDefinition() || this.isFieldUse();
    }

    public boolean isFieldNodeDU() {
        return this.isFieldNodeDefinition() || this.isFieldNodeUse();
    }

    public boolean isLocalDU() {
        return this.isLocalVariableDefinition() || this.isLocalVariableUse();
    }

    public boolean isDefinition() {
        return this.isFieldDefinition() || this.isLocalVariableDefinition();
    }

    public boolean isUse() {
        return this.isFieldUse() || this.isLocalVariableUse() || this.isArrayLoadInstruction();
    }

    public abstract boolean isFieldMethodCallDefinition();

    public abstract boolean isFieldMethodCallUse();

    public boolean isFieldDefinition() {
        return this.asmNode.getOpcode() == 181 || this.asmNode.getOpcode() == 179 || this.isFieldArrayDefinition() || this.isFieldMethodCallDefinition();
    }

    public boolean isFieldNodeDefinition() {
        return this.asmNode.getOpcode() == 181 || this.asmNode.getOpcode() == 179 || this.isFieldArrayDefinition();
    }

    public boolean isFieldUse() {
        return this.asmNode.getOpcode() == 180 || this.asmNode.getOpcode() == 178 || this.isFieldMethodCallUse();
    }

    public boolean isFieldNodeUse() {
        return this.asmNode.getOpcode() == 180 || this.asmNode.getOpcode() == 178;
    }

    public boolean isStaticDefUse() {
        return this.asmNode.getOpcode() == 179 || this.asmNode.getOpcode() == 178 || this.isStaticArrayUsage();
    }

    public String getVariableName() {
        if (this.isArrayStoreInstruction()) {
            return this.getArrayVariableName();
        }
        if (this.isArrayLoadInstruction()) {
            return this.getArrayVariableName();
        }
        if (this.isLocalDU()) {
            return this.getLocalVariableName();
        }
        if (this.isMethodCallOfField()) {
            return this.getFieldMethodCallName();
        }
        if (this.isFieldDU()) {
            return this.getFieldName();
        }
        return null;
    }

    protected String getFieldSimpleName() {
        FieldInsnNode fieldNode = (FieldInsnNode)this.asmNode;
        return fieldNode.name;
    }

    protected String getFieldName() {
        FieldInsnNode fieldNode = (FieldInsnNode)this.asmNode;
        return fieldNode.owner + "." + fieldNode.name;
    }

    public String getFieldType() {
        FieldInsnNode fieldNode = (FieldInsnNode)this.asmNode;
        return fieldNode.desc;
    }

    protected String getLocalVariableName() {
        String ret = this.getMethodName() + "_LV_" + this.getLocalVariableSlot();
        return ret;
    }

    public int getLocalVariableSlot() {
        if (this.asmNode instanceof VarInsnNode) {
            return ((VarInsnNode)this.asmNode).var;
        }
        if (this.asmNode instanceof IincInsnNode) {
            return ((IincInsnNode)this.asmNode).var;
        }
        return -1;
    }

    public boolean isLocalVariableDefinition() {
        return this.asmNode.getOpcode() == 54 || this.asmNode.getOpcode() == 55 || this.asmNode.getOpcode() == 56 || this.asmNode.getOpcode() == 57 || this.asmNode.getOpcode() == 58 || this.asmNode.getOpcode() == 132 || this.isLocalArrayDefinition();
    }

    public boolean isLocalVariableUse() {
        return this.asmNode.getOpcode() == 21 || this.asmNode.getOpcode() == 22 || this.asmNode.getOpcode() == 23 || this.asmNode.getOpcode() == 24 || this.asmNode.getOpcode() == 132 || this.asmNode.getOpcode() == 25 && !this.loadsReferenceToThis();
    }

    public boolean isIINC() {
        return this.asmNode.getOpcode() == 132;
    }

    public boolean loadsReferenceToThis() {
        if (this.getRawCFG().isStaticMethod()) {
            return false;
        }
        return this.asmNode.getOpcode() == 25 && this.getLocalVariableSlot() == 0;
    }

    public abstract RawControlFlowGraph getRawCFG();

    public boolean isLocalArrayDefinition() {
        if (!this.isArrayStoreInstruction()) {
            return false;
        }
        BytecodeInstruction arrayLoader = this.getSourceOfArrayReference();
        if (arrayLoader == null) {
            return false;
        }
        return arrayLoader.isLocalVariableUse();
    }

    public boolean isFieldArrayDefinition() {
        if (!this.isArrayStoreInstruction()) {
            return false;
        }
        BytecodeInstruction arrayLoader = this.getSourceOfArrayReference();
        if (arrayLoader == null) {
            return false;
        }
        return arrayLoader.isFieldUse();
    }

    public boolean isStaticArrayUsage() {
        if (!this.isArrayStoreInstruction()) {
            return false;
        }
        BytecodeInstruction arrayLoader = this.getSourceOfArrayReference();
        if (arrayLoader == null) {
            return false;
        }
        return arrayLoader.isStaticDefUse();
    }

    public boolean isArrayStoreInstruction() {
        return this.asmNode.getOpcode() == 79 || this.asmNode.getOpcode() == 80 || this.asmNode.getOpcode() == 81 || this.asmNode.getOpcode() == 82 || this.asmNode.getOpcode() == 83;
    }

    public boolean isArrayLoadInstruction() {
        return this.asmNode.getOpcode() == 46 || this.asmNode.getOpcode() == 47 || this.asmNode.getOpcode() == 48 || this.asmNode.getOpcode() == 49 || this.asmNode.getOpcode() == 50;
    }

    protected String getArrayVariableName() {
        BytecodeInstruction arrayLoader = this.getSourceOfArrayReference();
        if (arrayLoader == null) {
            return null;
        }
        return arrayLoader.getVariableName();
    }

    public abstract BytecodeInstruction getSourceOfArrayReference();

    public boolean isDefinitionForVariable(String var) {
        return this.isDefinition() && this.getVariableName().equals(var);
    }

    public boolean isInvokeSpecial() {
        return this.asmNode.getOpcode() == 183;
    }

    public boolean isConstructorInvocation() {
        if (!this.isInvokeSpecial()) {
            return false;
        }
        MethodInsnNode invoke = (MethodInsnNode)this.asmNode;
        return invoke.name.equals("<init>");
    }

    public boolean isConstructorInvocation(String className) {
        if (!this.isInvokeSpecial()) {
            return false;
        }
        MethodInsnNode invoke = (MethodInsnNode)this.asmNode;
        if (!invoke.owner.equals(className.replaceAll("\\.", "/"))) {
            return false;
        }
        return invoke.name.equals("<init>");
    }

    public boolean isLineNumber() {
        return this.asmNode instanceof LineNumberNode;
    }

    public int getLineNumber() {
        if (!this.isLineNumber()) {
            return -1;
        }
        return ((LineNumberNode)this.asmNode).line;
    }

    public boolean isLabel() {
        return this.asmNode instanceof LabelNode;
    }

    public boolean sanityCheckAbstractInsnNode(AbstractInsnNode node) {
        if (node == null) {
            return false;
        }
        return node.equals(this.asmNode);
    }
}

