/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import org.evosuite.graphs.cfg.CFGFrame;
import org.evosuite.graphs.cfg.CFGGenerator;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Analyzer;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Frame;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.SourceInterpreter;

public class BytecodeAnalyzer
extends Analyzer {
    CFGGenerator cfgGenerator;

    public BytecodeAnalyzer() {
        super(new SourceInterpreter());
    }

    public CFGFrame analyze(ClassLoader classLoader, String owner, String method, MethodNode node) throws AnalyzerException {
        this.cfgGenerator = new CFGGenerator(classLoader, owner, method, node);
        this.analyze(owner, node);
        Frame<V>[] frames = this.getFrames();
        if (frames.length == 0) {
            return null;
        }
        return (CFGFrame)this.getFrames()[0];
    }

    public CFGGenerator retrieveCFGGenerator() {
        if (this.cfgGenerator == null) {
            throw new IllegalStateException("you have to call analyze() first before retrieving the CFGGenerator");
        }
        return this.cfgGenerator;
    }

    @Override
    protected void newControlFlowEdge(int src, int dst) {
        this.cfgGenerator.registerControlFlowEdge(src, dst, this.getFrames(), false);
    }

    @Override
    protected boolean newControlFlowExceptionEdge(int src, int dst) {
        this.cfgGenerator.registerControlFlowEdge(src, dst, this.getFrames(), true);
        return true;
    }

    protected Frame newFrame(int nLocals, int nStack) {
        return new CFGFrame(nLocals, nStack);
    }

    protected Frame newFrame(Frame src) {
        return new CFGFrame(src);
    }
}

