/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionFactory;
import org.evosuite.runtime.instrumentation.AnnotatedLabel;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LabelNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LdcInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeInstructionPool {
    private static final Logger logger = LoggerFactory.getLogger(BytecodeInstructionPool.class);
    private static Map<ClassLoader, BytecodeInstructionPool> instanceMap = new LinkedHashMap<ClassLoader, BytecodeInstructionPool>();
    private final ClassLoader classLoader;
    private final Map<String, Map<String, List<BytecodeInstruction>>> instructionMap = new LinkedHashMap<String, Map<String, List<BytecodeInstruction>>>();
    private final List<MethodNode> knownMethodNodes = new ArrayList<MethodNode>();

    private BytecodeInstructionPool(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static BytecodeInstructionPool getInstance(ClassLoader classLoader) {
        if (!instanceMap.containsKey(classLoader)) {
            instanceMap.put(classLoader, new BytecodeInstructionPool(classLoader));
        }
        return instanceMap.get(classLoader);
    }

    public List<BytecodeInstruction> registerMethodNode(MethodNode node, String className, String methodName) {
        this.registerMethodNode(node);
        int lastLineNumber = -1;
        int bytecodeOffset = 0;
        for (int instructionId = 0; instructionId < node.instructions.size(); ++instructionId) {
            AbstractInsnNode instructionNode = node.instructions.get(instructionId);
            BytecodeInstruction instruction = BytecodeInstructionFactory.createBytecodeInstruction(this.classLoader, className, methodName, instructionId, bytecodeOffset, instructionNode);
            if (instruction.isLineNumber()) {
                lastLineNumber = instruction.getLineNumber();
            } else if (lastLineNumber != -1) {
                instruction.setLineNumber(lastLineNumber);
            }
            bytecodeOffset += this.getBytecodeIncrement(instructionNode);
            if (!(instruction.isLabel() || instruction.isLineNumber() || instruction.isFrame())) {
                ++bytecodeOffset;
            }
            this.registerInstruction(instruction);
        }
        List<BytecodeInstruction> r = this.getInstructionsIn(className, methodName);
        if (r == null || r.size() == 0) {
            throw new IllegalStateException("expect instruction pool to return non-null non-empty list of instructions for a previously registered method " + methodName);
        }
        return r;
    }

    private int getBytecodeIncrement(AbstractInsnNode instructionNode) {
        int opcode = instructionNode.getOpcode();
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                VarInsnNode varNode = (VarInsnNode)instructionNode;
                if (varNode.var > 3) {
                    return 1;
                }
                return 0;
            }
            case 16: 
            case 169: 
            case 188: {
                return 1;
            }
            case 18: {
                LdcInsnNode ldcNode = (LdcInsnNode)instructionNode;
                if (ldcNode.cst instanceof Double || ldcNode.cst instanceof Long) {
                    return 2;
                }
                return 1;
            }
            case 19: 
            case 20: {
                return 2;
            }
            case 17: 
            case 132: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 198: 
            case 199: {
                return 2;
            }
            case 197: {
                return 3;
            }
            case 185: 
            case 186: {
                return 4;
            }
            case 170: 
            case 171: {
                return 4;
            }
        }
        return 0;
    }

    private void registerMethodNode(MethodNode node) {
        for (MethodNode mn : this.knownMethodNodes) {
            if (mn != node) continue;
            logger.debug("CFGGenerator.analyze() apparently got called for the same MethodNode twice");
        }
        this.knownMethodNodes.add(node);
    }

    public void registerInstruction(BytecodeInstruction instruction) {
        AnnotatedLabel aLabel;
        LabelNode ln;
        BytecodeInstruction previous;
        String className = instruction.getClassName();
        String methodName = instruction.getMethodName();
        if (!this.instructionMap.containsKey(className)) {
            this.instructionMap.put(className, new LinkedHashMap());
        }
        if (!this.instructionMap.get(className).containsKey(methodName)) {
            this.instructionMap.get(className).put(methodName, new ArrayList());
        }
        this.instructionMap.get(className).get(methodName).add(instruction);
        logger.debug("Registering instruction " + instruction);
        List<BytecodeInstruction> instructions = this.instructionMap.get(className).get(methodName);
        if (instructions.size() > 1 && (previous = instructions.get(instructions.size() - 2)).isLabel() && (ln = (LabelNode)previous.asmNode).getLabel() instanceof AnnotatedLabel && (aLabel = (AnnotatedLabel)ln.getLabel()).isStartTag() && aLabel.shouldIgnore()) {
            logger.debug("Ignoring artificial branch: " + instruction);
            return;
        }
        if (instruction.isActualBranch()) {
            BranchPool.getInstance(this.classLoader).registerAsBranch(instruction);
        }
    }

    public BytecodeInstruction getInstruction(String className, String methodName, int instructionId, AbstractInsnNode asmNode) {
        BytecodeInstruction r = this.getInstruction(className, methodName, instructionId);
        if (r != null) assert (r.sanityCheckAbstractInsnNode(asmNode));
        return r;
    }

    public BytecodeInstruction getInstruction(String className, String methodName, int instructionId) {
        if (this.instructionMap.get(className) == null) {
            logger.debug("unknown class: " + className);
            logger.debug(this.instructionMap.keySet().toString());
            return null;
        }
        if (this.instructionMap.get(className).get(methodName) == null) {
            logger.debug("unknown method: " + methodName);
            logger.debug(this.instructionMap.get(className).keySet().toString());
            return null;
        }
        for (BytecodeInstruction instruction : this.instructionMap.get(className).get(methodName)) {
            if (instruction.getInstructionId() != instructionId) continue;
            return instruction;
        }
        logger.debug("unknown instruction " + instructionId + ", have " + this.instructionMap.get(className).get(methodName).size());
        for (int i = 0; i < this.instructionMap.get(className).get(methodName).size(); ++i) {
            logger.info(this.instructionMap.get(className).get(methodName).get(i).toString());
        }
        return null;
    }

    public BytecodeInstruction getInstruction(String className, String methodName, AbstractInsnNode node) {
        if (this.instructionMap.get(className) == null) {
            logger.debug("unknown class: " + className);
            logger.debug(this.instructionMap.keySet().toString());
            return null;
        }
        if (this.instructionMap.get(className).get(methodName) == null) {
            logger.debug("unknown method: " + methodName);
            logger.debug(this.instructionMap.get(className).keySet().toString());
            return null;
        }
        for (BytecodeInstruction instruction : this.instructionMap.get(className).get(methodName)) {
            if (instruction.asmNode != node) continue;
            return instruction;
        }
        logger.debug("unknown instruction: " + node + ", have " + this.instructionMap.get(className).get(methodName).size() + " instructions for this method");
        logger.debug(this.instructionMap.get(className).get(methodName).toString());
        return null;
    }

    public Set<String> knownClasses() {
        return new LinkedHashSet<String>(this.instructionMap.keySet());
    }

    public Set<String> knownMethods(String className) {
        LinkedHashSet<String> r = new LinkedHashSet<String>();
        if (this.instructionMap.get(className) != null) {
            r.addAll(this.instructionMap.get(className).keySet());
        }
        return r;
    }

    public boolean hasMethod(String className, String methodName) {
        if (this.instructionMap.get(className) != null) {
            return this.instructionMap.get(className).containsKey(methodName);
        }
        return false;
    }

    public List<BytecodeInstruction> getInstructionsIn(String className, String methodName) {
        if (this.instructionMap.get(className) == null || this.instructionMap.get(className).get(methodName) == null) {
            return null;
        }
        ArrayList<BytecodeInstruction> r = new ArrayList<BytecodeInstruction>((Collection)this.instructionMap.get(className).get(methodName));
        return r;
    }

    public List<BytecodeInstruction> getInstructionsIn(String className) {
        if (this.instructionMap.get(className) == null) {
            return null;
        }
        ArrayList<BytecodeInstruction> r = new ArrayList<BytecodeInstruction>();
        Map<String, List<BytecodeInstruction>> methodMap = this.instructionMap.get(className);
        for (List<BytecodeInstruction> methodInstructions : methodMap.values()) {
            r.addAll(methodInstructions);
        }
        return r;
    }

    public List<BytecodeInstruction> getAllInstructions() {
        ArrayList<BytecodeInstruction> r = new ArrayList<BytecodeInstruction>();
        for (String className : this.instructionMap.keySet()) {
            Map<String, List<BytecodeInstruction>> methodMap = this.instructionMap.get(className);
            for (List<BytecodeInstruction> methodInstructions : methodMap.values()) {
                r.addAll(methodInstructions);
            }
        }
        return r;
    }

    public void logInstructionsIn(String className, String methodName) {
        logger.debug("Printing instructions in " + className + "." + methodName + ":");
        List<BytecodeInstruction> instructions = this.getInstructionsIn(className, methodName);
        if (instructions == null) {
            logger.debug("..unknown method");
        } else {
            for (BytecodeInstruction instruction : instructions) {
                logger.debug("\t" + instruction);
            }
        }
    }

    public BytecodeInstruction createFakeInstruction(String className, String methodName) {
        InsnNode fakeNode = new InsnNode(0);
        int instructionId = this.getInstructionsIn(className, methodName).size();
        BytecodeInstruction instruction = new BytecodeInstruction(this.classLoader, className, methodName, instructionId, -1, fakeNode);
        this.registerInstruction(instruction);
        return instruction;
    }

    public void clear() {
        this.instructionMap.clear();
        this.knownMethodNodes.clear();
    }

    public static void clearAll() {
        instanceMap.clear();
    }

    public void clear(String className) {
        this.instructionMap.remove(className);
    }

    public static void clearAll(String className) {
        for (BytecodeInstructionPool pool : instanceMap.values()) {
            pool.clear(className);
        }
    }

    public void clear(String className, String methodName) {
        if (this.instructionMap.containsKey(className)) {
            this.instructionMap.get(className).remove(methodName);
        }
    }

    public static void clearAll(String className, String methodName) {
        for (BytecodeInstructionPool pool : instanceMap.values()) {
            pool.clear(className, methodName);
        }
    }

    public boolean forgetInstruction(BytecodeInstruction ins) {
        if (!this.instructionMap.containsKey(ins.getClassName())) {
            return false;
        }
        if (!this.instructionMap.get(ins.getClassName()).containsKey(ins.getMethodName())) {
            return false;
        }
        return this.instructionMap.get(ins.getClassName()).get(ins.getMethodName()).remove(ins);
    }

    public int getFirstLineNumberOfMethod(String className, String methodName) {
        if (this.instructionMap.get(className) == null) {
            throw new IllegalArgumentException("unknown class " + className);
        }
        if (this.instructionMap.get(className).get(methodName) == null) {
            throw new IllegalArgumentException("unknown method " + methodName + " in class " + className);
        }
        if (this.instructionMap.get(className).get(methodName).isEmpty()) {
            throw new IllegalArgumentException("no instructions in method " + methodName + " in class " + className);
        }
        int r = Integer.MAX_VALUE;
        for (BytecodeInstruction ins : this.instructionMap.get(className).get(methodName)) {
            if (ins.getLineNumber() >= r) continue;
            r = ins.getLineNumber();
        }
        return r;
    }

    public BytecodeInstruction getFirstInstructionAtLineNumber(String className, String methodName, int lineNumber) {
        if (this.instructionMap.get(className) == null) {
            return null;
        }
        if (this.instructionMap.get(className).get(methodName) == null) {
            return null;
        }
        if (this.instructionMap.get(className).get(methodName).isEmpty()) {
            return null;
        }
        for (BytecodeInstruction ins : this.instructionMap.get(className).get(methodName)) {
            if (ins.getLineNumber() != lineNumber) continue;
            return ins;
        }
        return null;
    }
}

