/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import org.evosuite.classpath.ResourceList;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.runtime.instrumentation.RemoveFinalClassAdapter;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.shaded.org.objectweb.asm.commons.JSRInlinerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFGClassAdapter
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CFGClassAdapter.class);
    private final String className;
    private final ClassLoader classLoader;
    private boolean isEnum = false;

    public CFGClassAdapter(ClassLoader classLoader, ClassVisitor visitor, String className) {
        super(589824, visitor);
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x10) == 16) {
            RemoveFinalClassAdapter.finalClasses.add(name.replace('/', '.'));
        }
        super.visit(version, access & 0xFFFFFFEF, name, signature, superName, interfaces);
        if (superName.equals("java/lang/Enum")) {
            this.isEnum = true;
        }
    }

    @Override
    public MethodVisitor visitMethod(int methodAccess, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(methodAccess, name, descriptor, signature, exceptions);
        mv = new JSRInlinerAdapter(mv, methodAccess, name, descriptor, signature, exceptions);
        if ((methodAccess & 0x1000) != 0 || (methodAccess & 0x40) != 0) {
            return mv;
        }
        if (this.isEnum) {
            if (name.equals("valueOf") || name.equals("values")) {
                logger.info("Skipping enum valueOf");
                return mv;
            }
            if (name.equals("<init>") && descriptor.equals("(Ljava/lang/String;I)V")) {
                logger.info("Skipping enum default constructor");
                return mv;
            }
        }
        logger.info("Analyzing CFG of " + this.className);
        String classNameWithDots = ResourceList.getClassNameFromResourcePath(this.className);
        mv = new CFGMethodAdapter(this.classLoader, classNameWithDots, methodAccess, name, descriptor, signature, exceptions, mv);
        return mv;
    }
}

