/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.classpath.ResourceList;
import org.evosuite.graphs.cfg.CFGClassAdapter;
import org.evosuite.instrumentation.AccessibleClassAdapter;
import org.evosuite.instrumentation.EndOfClassInitializerVisitor;
import org.evosuite.instrumentation.ExceptionTransformationClassAdapter;
import org.evosuite.instrumentation.ExecutionPathClassAdapter;
import org.evosuite.instrumentation.NonTargetClassAdapter;
import org.evosuite.instrumentation.PurityAnalysisClassVisitor;
import org.evosuite.instrumentation.StaticAccessClassAdapter;
import org.evosuite.instrumentation.TransformationStatistics;
import org.evosuite.instrumentation.error.ErrorConditionClassAdapter;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.testability.ComparisonTransformation;
import org.evosuite.instrumentation.testability.ContainerTransformation;
import org.evosuite.instrumentation.testability.StringTransformation;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.instrumentation.AnnotatedClassNode;
import org.evosuite.runtime.instrumentation.CreateClassResetClassAdapter;
import org.evosuite.runtime.instrumentation.LoopCounterClassAdapter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementClassAdapter;
import org.evosuite.runtime.instrumentation.RemoveFinalClassAdapter;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;
import org.evosuite.runtime.util.ComputeClassWriter;
import org.evosuite.seeding.PrimitiveClassAdapter;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.evosuite.shaded.org.objectweb.asm.ClassWriter;
import org.evosuite.shaded.org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.evosuite.shaded.org.objectweb.asm.util.TraceClassVisitor;
import org.evosuite.testcarver.instrument.Instrumenter;
import org.evosuite.testcarver.instrument.TransformerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytecodeInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(BytecodeInstrumentation.class);
    private final Instrumenter testCarvingInstrumenter = new Instrumenter();

    private static String[] getEvoSuitePackages() {
        return new String[]{PackageInfo.getEvoSuitePackage(), "org.exsyst", "de.unisb.cs.st.testcarver", "de.unisb.cs.st.evosuite", "testing.generation.evosuite", "de.unisl.cs.st.bugex"};
    }

    public static boolean checkIfCanInstrument(String className) {
        return RuntimeInstrumentation.checkIfCanInstrument(className);
    }

    public static boolean checkIfEvoSuitePackage(String className) {
        for (String s : BytecodeInstrumentation.getEvoSuitePackages()) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldTransform(String className) {
        if (!Properties.TT) {
            return false;
        }
        switch (Properties.TT_SCOPE) {
            case ALL: {
                logger.info("Allowing transformation of " + className);
                return true;
            }
            case TARGET: {
                if (!className.equals(Properties.TARGET_CLASS) && !className.startsWith(Properties.TARGET_CLASS + "$")) break;
                return true;
            }
            case PREFIX: {
                if (!className.startsWith(Properties.PROJECT_PREFIX)) break;
                return true;
            }
        }
        logger.info("Preventing transformation of " + className);
        return false;
    }

    private boolean isTargetClassName(String className) {
        return TestCluster.isTargetClassName(className);
    }

    public byte[] transformBytes(ClassLoader classLoader, String className, ClassReader reader) {
        ComputeClassWriter writer;
        String classNameWithDots;
        int readFlags = 4;
        if (Properties.INSTRUMENTATION_SKIP_DEBUG) {
            readFlags |= 2;
        }
        if (!BytecodeInstrumentation.checkIfCanInstrument(classNameWithDots = ResourceList.getClassNameFromResourcePath(className))) {
            throw new RuntimeException("Should not transform a shared class (" + classNameWithDots + ")! Load by parent (JVM) classloader.");
        }
        TransformationStatistics.reset();
        int asmFlags = 2;
        ClassVisitor cv = writer = new ComputeClassWriter(asmFlags);
        if (logger.isDebugEnabled()) {
            cv = new TraceClassVisitor(cv, new PrintWriter(System.err));
        }
        if (Properties.RESET_STATIC_FIELDS) {
            cv = new StaticAccessClassAdapter(cv, className);
        }
        if (Properties.PURE_INSPECTORS) {
            CheapPurityAnalyzer purityAnalyzer = CheapPurityAnalyzer.getInstance();
            cv = new PurityAnalysisClassVisitor(cv, className, purityAnalyzer);
        }
        if (Properties.MAX_LOOP_ITERATIONS >= 0L) {
            cv = new LoopCounterClassAdapter(cv);
        }
        if (DependencyAnalysis.shouldAnalyze(classNameWithDots)) {
            logger.debug("Applying target transformation to class " + classNameWithDots);
            if (!Properties.TEST_CARVING && Properties.MAKE_ACCESSIBLE) {
                cv = new AccessibleClassAdapter(cv, className);
            }
            cv = new RemoveFinalClassAdapter(cv);
            cv = new ExecutionPathClassAdapter(cv, className);
            cv = new CFGClassAdapter(classLoader, cv, className);
            if (Properties.EXCEPTION_BRANCHES) {
                cv = new ExceptionTransformationClassAdapter(cv, className);
            }
            if (Properties.ERROR_BRANCHES) {
                cv = new ErrorConditionClassAdapter(cv, className);
            }
        } else {
            logger.debug("Not applying target transformation");
            cv = new NonTargetClassAdapter(cv, className);
            if (Properties.MAKE_ACCESSIBLE) {
                cv = new AccessibleClassAdapter(cv, className);
            }
            if (Properties.TT && classNameWithDots.startsWith(Properties.CLASS_PREFIX)) {
                cv = new CFGClassAdapter(classLoader, cv, className);
            }
        }
        cv = new PrimitiveClassAdapter(cv, className);
        if (Properties.RESET_STATIC_FIELDS) {
            cv = BytecodeInstrumentation.handleStaticReset(className, cv);
        }
        if (TestSuiteWriterUtils.needToUseAgent()) {
            cv = new MethodCallReplacementClassAdapter(cv, className);
            if (RuntimeSettings.applyUIDTransformation) {
                cv = new SerialVersionUIDAdder(cv);
            }
        }
        if (classNameWithDots.startsWith(Properties.PROJECT_PREFIX) || !Properties.TARGET_CLASS_PREFIX.isEmpty() && classNameWithDots.startsWith(Properties.TARGET_CLASS_PREFIX) || this.shouldTransform(classNameWithDots)) {
            ClassNode cn = new AnnotatedClassNode();
            reader.accept(cn, readFlags);
            logger.info("Starting transformation of " + className);
            if (Properties.STRING_REPLACEMENT) {
                StringTransformation st = new StringTransformation(cn);
                if (this.isTargetClassName(classNameWithDots) || this.shouldTransform(classNameWithDots)) {
                    cn = st.transform();
                }
            }
            ComparisonTransformation cmp = new ComparisonTransformation(cn);
            if (this.isTargetClassName(classNameWithDots) || this.shouldTransform(classNameWithDots)) {
                cn = cmp.transform();
                ContainerTransformation ct = new ContainerTransformation(cn);
                cn = ct.transform();
            }
            if (this.shouldTransform(classNameWithDots)) {
                logger.info("Testability Transforming " + className);
                BooleanTestabilityTransformation tt = new BooleanTestabilityTransformation(cn, classLoader);
                try {
                    cn = tt.transform();
                }
                catch (Throwable t) {
                    throw new Error(t);
                }
                logger.info("Testability Transformation done: " + className);
            }
            cn.accept(cv);
            if (Properties.TEST_CARVING && TransformerUtil.isClassConsideredForInstrumentation(className)) {
                return this.handleCarving(className, writer);
            }
        } else {
            reader.accept(cv, readFlags);
        }
        return writer.toByteArray();
    }

    private byte[] handleCarving(String className, ClassWriter writer) {
        ClassReader cr = new ClassReader(writer.toByteArray());
        ClassNode cn2 = new ClassNode();
        cr.accept(cn2, 8);
        this.testCarvingInstrumenter.transformClassNode(cn2, className);
        ClassWriter cw = new ClassWriter(1);
        cn2.accept(cw);
        if (logger.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            cn2.accept(new TraceClassVisitor(new PrintWriter(sw)));
            logger.debug("test carving instrumentation result:\n{}", (Object)sw);
        }
        return cw.toByteArray();
    }

    private static ClassVisitor handleStaticReset(String className, ClassVisitor cv) {
        CreateClassResetClassAdapter resetClassAdapter = Properties.RESET_STATIC_FINAL_FIELDS ? new CreateClassResetClassAdapter(cv, className, true) : new CreateClassResetClassAdapter(cv, className, false);
        cv = resetClassAdapter;
        EndOfClassInitializerVisitor exitClassInitAdapter = new EndOfClassInitializerVisitor(cv, className);
        cv = exitClassInitAdapter;
        return cv;
    }
}

