/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ResourceList;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentingClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentingClassLoader.class);
    private final BytecodeInstrumentation instrumentation;
    private final ClassLoader classLoader;
    private final Map<String, Class<?>> classes = new HashMap();

    public InstrumentingClassLoader() {
        this(new BytecodeInstrumentation());
        this.setClassAssertionStatus(Properties.TARGET_CLASS, true);
        logger.debug("STANDARD classloader running now");
    }

    public InstrumentingClassLoader(BytecodeInstrumentation instrumentation) {
        super(InstrumentingClassLoader.class.getClassLoader());
        this.classLoader = InstrumentingClassLoader.class.getClassLoader();
        this.instrumentation = instrumentation;
    }

    public List<String> getViewOfInstrumentedClasses() {
        ArrayList<String> list = new ArrayList<String>(this.classes.keySet());
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class<?> loadClassFromFile(String fullyQualifiedTargetClass, String fileName) throws ClassNotFoundException {
        String className = fullyQualifiedTargetClass.replace('.', '/');
        try (FileInputStream is = new FileInputStream(new File(fileName));){
            byte[] byteBuffer = this.getTransformedBytes(className, is);
            this.createPackageDefinition(fullyQualifiedTargetClass);
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            logger.info("Loaded class " + fullyQualifiedTargetClass + " directly from " + fileName);
            Class<?> clazz = result;
            return clazz;
        }
        catch (Throwable t) {
            logger.info("Error while loading class " + fullyQualifiedTargetClass + " : " + t);
            throw new ClassNotFoundException(t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            if ("<evosuite>".equals(name)) {
                throw new ClassNotFoundException();
            }
            if (!RuntimeInstrumentation.checkIfCanInstrument(name)) {
                Class<?> result = this.findLoadedClass(name);
                if (result != null) {
                    return result;
                }
                result = this.classLoader.loadClass(name);
                return result;
            }
            Class<?> result = this.classes.get(name);
            if (result != null) {
                return result;
            }
            logger.info("Seeing class for first time: " + name);
            Class<?> instrumentedClass = this.instrumentClass(name);
            return instrumentedClass;
        }
    }

    protected byte[] getTransformedBytes(String className, InputStream is) throws IOException {
        return this.instrumentation.transformBytes(this, className, new ClassReader(is));
    }

    private Class<?> instrumentClass(String fullyQualifiedTargetClass) throws ClassNotFoundException {
        String className = fullyQualifiedTargetClass.replace('.', '/');
        InputStream is = null;
        try {
            is = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(fullyQualifiedTargetClass);
            if (is == null) {
                throw new ClassNotFoundException("Class '" + className + ".class' should be in target project, but could not be found!");
            }
            byte[] byteBuffer = this.getTransformedBytes(className, is);
            this.createPackageDefinition(fullyQualifiedTargetClass);
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            logger.info("Loaded class: " + fullyQualifiedTargetClass);
            Class<?> clazz = result;
            return clazz;
        }
        catch (Throwable t) {
            logger.info("Error while loading class: " + t);
            throw new ClassNotFoundException(t.getMessage(), t);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
    }

    private void createPackageDefinition(String className) {
        String pkgname;
        Package pkg;
        int i = className.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgname = className.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
            logger.info("Defined package (3): " + this.getPackage(pkgname) + ", " + this.getPackage(pkgname).hashCode());
        }
    }

    public BytecodeInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public Set<String> getLoadedClasses() {
        HashSet<String> loadedClasses = new HashSet<String>(this.classes.keySet());
        return loadedClasses;
    }
}

