/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LinePool {
    private static Map<String, Map<String, Set<Integer>>> lineMap = new LinkedHashMap<String, Map<String, Set<Integer>>>();

    public static void addLine(String className, String methodName, int lineNo) {
        if (!lineMap.containsKey(className)) {
            lineMap.put(className, new LinkedHashMap());
        }
        if (!lineMap.get(className).containsKey(methodName)) {
            lineMap.get(className).put(methodName, new LinkedHashSet());
        }
        lineMap.get(className).get(methodName).add(lineNo);
    }

    public static Set<Integer> getLines(String className, String methodName) {
        if (lineMap.containsKey(className) && lineMap.get(className).containsKey(methodName)) {
            return lineMap.get(className).get(methodName);
        }
        return new HashSet<Integer>();
    }

    public static Set<Integer> getLines(String className) {
        LinkedHashSet<Integer> lines = new LinkedHashSet<Integer>();
        if (lineMap.containsKey(className)) {
            for (Set<Integer> methodLines : lineMap.get(className).values()) {
                lines.addAll(methodLines);
            }
        }
        return lines;
    }

    public static Set<Integer> getAllLines() {
        LinkedHashSet<Integer> lines = new LinkedHashSet<Integer>();
        for (String className : lineMap.keySet()) {
            for (Set<Integer> methodLines : lineMap.get(className).values()) {
                lines.addAll(methodLines);
            }
        }
        return lines;
    }

    public static int getNumLines() {
        int num = 0;
        for (String className : lineMap.keySet()) {
            num += lineMap.get(className).size();
        }
        return num;
    }

    public static Set<String> getKnownClasses() {
        return new HashSet<String>(lineMap.keySet());
    }

    public static Set<String> getKnownMethodsFor(String className) {
        if (!lineMap.containsKey(className)) {
            return new HashSet<String>();
        }
        return lineMap.get(className).keySet();
    }

    public static void removeClass(String className) {
        lineMap.remove(className);
    }

    public static void reset() {
        lineMap.clear();
    }
}

