/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.IntInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LdcInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Frame;

public class ReplaceConstant
implements MutationOperator {
    public static final String NAME = "ReplaceConstant";

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        Object value = this.getValue(instruction.getASMNode());
        for (Object replacement : this.getReplacement(value)) {
            LdcInsnNode mutation = new LdcInsnNode(replacement);
            String summary = "ReplaceConstant - " + value + " -> " + replacement;
            if (replacement instanceof String) {
                summary = summary.replace("*/", "*_/");
            }
            Mutation mutationObject = MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).addMutation(className, methodName, summary, instruction, mutation, Mutation.getDefaultInfectionDistance());
            mutations.add(mutationObject);
        }
        return mutations;
    }

    private Object getValue(AbstractInsnNode constant) {
        switch (constant.getOpcode()) {
            case 18: {
                return ((LdcInsnNode)constant).cst;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 2: {
                return -1;
            }
            case 9: {
                return 0L;
            }
            case 10: {
                return 1L;
            }
            case 14: {
                return 0.0;
            }
            case 15: {
                return 1.0;
            }
            case 11: {
                return Float.valueOf(0.0f);
            }
            case 12: {
                return Float.valueOf(1.0f);
            }
            case 13: {
                return Float.valueOf(2.0f);
            }
            case 17: {
                return ((IntInsnNode)constant).operand;
            }
            case 16: {
                return ((IntInsnNode)constant).operand;
            }
        }
        throw new RuntimeException("Unknown constant: " + constant.getOpcode());
    }

    private Object[] getReplacement(Object value) {
        if (value instanceof Integer) {
            return this.getReplacement((Integer)value);
        }
        if (value instanceof Float) {
            return this.getReplacement(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.getReplacement((Double)value);
        }
        if (value instanceof Long) {
            return this.getReplacement((Long)value);
        }
        if (value instanceof String) {
            return this.getReplacement((String)value);
        }
        if (value instanceof Type) {
            return new Object[0];
        }
        throw new RuntimeException("Unknown type of constant: " + value);
    }

    private Object[] getReplacement(int value) {
        LinkedList<Integer> values = new LinkedList<Integer>();
        if (value == 0) {
            values.add(1);
        } else if (value == 1) {
            values.add(0);
        } else {
            if (value != 0) {
                values.add(0);
            }
            if (value != 1) {
                values.add(1);
            }
            if (value != -1) {
                values.add(-1);
            }
            if (!values.contains(value - 1)) {
                values.add(value - 1);
            }
            if (!values.contains(value + 1)) {
                values.add(value + 1);
            }
        }
        return values.toArray();
    }

    private Object[] getReplacement(long value) {
        LinkedList<Long> values = new LinkedList<Long>();
        if (value != 0L) {
            values.add(0L);
        }
        if (value != 1L) {
            values.add(1L);
        }
        if (value != -1L) {
            values.add(-1L);
        }
        if (!values.contains(value - 1L)) {
            values.add(value - 1L);
        }
        if (!values.contains(value + 1L)) {
            values.add(value + 1L);
        }
        return values.toArray();
    }

    private Object[] getReplacement(float value) {
        LinkedList<Float> values = new LinkedList<Float>();
        if (value != 0.0f) {
            values.add(Float.valueOf(0.0f));
        }
        if (value != 1.0f) {
            values.add(Float.valueOf(1.0f));
        }
        if (value != -1.0f) {
            values.add(Float.valueOf(-1.0f));
        }
        if (!values.contains(Float.valueOf(value - 1.0f))) {
            values.add(Float.valueOf(value - 1.0f));
        }
        if (!values.contains(Float.valueOf(value + 1.0f))) {
            values.add(Float.valueOf(value + 1.0f));
        }
        return values.toArray();
    }

    private Object[] getReplacement(double value) {
        LinkedList<Double> values = new LinkedList<Double>();
        if (value != 0.0) {
            values.add(0.0);
        }
        if (value != 1.0) {
            values.add(1.0);
        }
        if (value != -1.0) {
            values.add(-1.0);
        }
        if (!values.contains(value - 1.0)) {
            values.add(value - 1.0);
        }
        if (!values.contains(value + 1.0)) {
            values.add(value + 1.0);
        }
        return values.toArray();
    }

    private Object[] getReplacement(String value) {
        LinkedList<String> values = new LinkedList<String>();
        if (!value.equals("")) {
            values.add("");
        }
        return values.toArray();
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        return instruction.isConstant();
    }
}

