/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.evosuite.ClientProcess;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TestSuiteGenerator;
import org.evosuite.annotations.EvoSuiteTest;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.evosuite.coverage.CoverageCriteriaAnalyzer;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.junit.CoverageReportGenerator;
import org.evosuite.junit.JUnitResult;
import org.evosuite.junit.JUnitRunner;
import org.evosuite.rmi.ClientServices;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.StatisticsSender;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.factories.JUnitTestCarvedChromosomeFactory;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ExternalProcessUtilities;
import org.evosuite.utils.LoggingUtils;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverageAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(CoverageAnalysis.class);
    private static int totalGoals = 0;
    private static int totalCoveredGoals = 0;
    private static Set<String> targetClasses = new LinkedHashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyzeCoverage() {
        Sandbox.goingToExecuteSUTCode();
        TestGenerationContext.getInstance().goingToExecuteSUTCode();
        Sandbox.goingToExecuteUnsafeCodeOnSameThread();
        ExecutionTracer.setCheckCallerThread(false);
        try {
            String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
            if (Properties.TARGET_CLASS.endsWith(".jar") || Properties.TARGET_CLASS.contains(File.separator)) {
                targetClasses = DependencyAnalysis.analyzeTarget(Properties.TARGET_CLASS, Arrays.asList(cp.split(File.pathSeparator)));
            } else {
                targetClasses.add(Properties.TARGET_CLASS);
                DependencyAnalysis.analyzeClass(Properties.TARGET_CLASS, Arrays.asList(cp.split(File.pathSeparator)));
            }
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Finished analyzing classpath");
        }
        catch (Throwable e) {
            LoggingUtils.getEvoLogger().error("* " + ClientProcess.getPrettyPrintIdentifier() + "Error while initializing target class: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
            logger.error("Problem for " + Properties.TARGET_CLASS + ". Full stack:", e);
            return;
        }
        finally {
            Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
            Sandbox.doneWithExecutingSUTCode();
            TestGenerationContext.getInstance().doneWithExecutingSUTCode();
        }
        List<Class<?>> testClasses = CoverageAnalysis.getTestClasses();
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Found " + testClasses.size() + " test class(es)");
        if (testClasses.isEmpty()) {
            return;
        }
        CoverageAnalysis.sortTestClasses(testClasses);
        Class[] tests = testClasses.toArray(new Class[testClasses.size()]);
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Executing test(s)");
        if (Properties.SELECTED_JUNIT == null) {
            boolean origUseAgent = EvoRunner.useAgent;
            boolean origUseClassLoader = EvoRunner.useClassLoader;
            try {
                EvoRunner.useAgent = false;
                EvoRunner.useClassLoader = false;
                List<JUnitResult> results = CoverageAnalysis.executeTests(tests);
                CoverageAnalysis.printReport(results);
            }
            finally {
                EvoRunner.useAgent = origUseAgent;
                EvoRunner.useClassLoader = origUseClassLoader;
            }
        } else {
            JUnitTestCarvedChromosomeFactory carvedFactory = new JUnitTestCarvedChromosomeFactory(null);
            TestSuiteChromosome testSuite = carvedFactory.getCarvedTestSuite();
            int goals = 0;
            for (Properties.Criterion pc : Properties.CRITERION) {
                LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Coverage analysis for criterion " + (Object)((Object)pc));
                TestFitnessFactory<? extends TestFitnessFunction> ffactory = FitnessFunctions.getFitnessFactory(pc);
                goals += ffactory.getCoverageGoals().size();
                TestSuiteFitnessFunction ffunction = FitnessFunctions.getFitnessFunction(pc);
                ffunction.getFitness(testSuite);
                CoverageCriteriaAnalyzer.analyzeCoverage(testSuite, pc);
            }
            TestSuiteGenerator.writeJUnitTestsAndCreateResult(testSuite);
            StatisticsSender.executedAndThenSendIndividualToMaster(testSuite);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals);
            if (Properties.COVERAGE_MATRIX) {
                throw new IllegalArgumentException("Coverage matrix not yet available when measuring coverage of a carved test suite");
            }
        }
    }

    public static Set<TestFitnessFunction> getCoveredGoals(Class<?> testClass, List<TestFitnessFunction> allGoals) {
        TestChromosome dummy = new TestChromosome();
        dummy.setChanged(false);
        ExecutionResult executionResult = new ExecutionResult(dummy.getTestCase());
        HashSet<TestFitnessFunction> coveredGoals = new HashSet<TestFitnessFunction>();
        List<JUnitResult> results = CoverageAnalysis.executeTests(testClass);
        for (JUnitResult testResult : results) {
            executionResult.setTrace(testResult.getExecutionTrace());
            dummy.setLastExecutionResult(executionResult);
            for (TestFitnessFunction goal : allGoals) {
                if (!goal.isCovered(dummy)) continue;
                coveredGoals.add(goal);
            }
        }
        return coveredGoals;
    }

    private static List<Class<?>> getTestClassesFromClasspath() {
        ArrayList classes = new ArrayList();
        for (String prefix : Properties.JUNIT.split(":")) {
            Set<String> suts = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), prefix, false);
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Found " + suts.size() + " classes with prefix '" + prefix + "'");
            if (suts.isEmpty()) continue;
            for (String sut : suts) {
                if (targetClasses.contains(sut)) continue;
                try {
                    Class<?> clazz = Class.forName(sut, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                    if (!CoverageAnalysis.isTest(clazz)) continue;
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e2) {
                    logger.info("Could not find class " + sut);
                }
                catch (Throwable t) {
                    logger.info("Error while initialising class " + sut);
                }
            }
        }
        return classes;
    }

    private static List<Class<?>> getTestClasses() {
        ArrayList testClasses = new ArrayList();
        logger.debug("JUNIT: " + Properties.JUNIT);
        for (String prefix : Properties.JUNIT.split(":")) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Analyzing entry: " + prefix);
            File path = new File(prefix);
            if (path.exists()) {
                if (Properties.JUNIT.endsWith(".jar")) {
                    testClasses.addAll(CoverageAnalysis.getTestClassesJar(path));
                    continue;
                }
                testClasses.addAll(CoverageAnalysis.getTestClasses(path));
                continue;
            }
            try {
                Class<?> clazz = Class.forName(prefix, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                testClasses.add(clazz);
            }
            catch (ClassNotFoundException e) {
                testClasses.addAll(CoverageAnalysis.getTestClassesFromClasspath());
            }
        }
        return testClasses;
    }

    private static List<Class<?>> getTestClasses(File directory) {
        ArrayList testClasses = new ArrayList();
        if (directory.getName().endsWith(".class")) {
            LoggingUtils.muteCurrentOutAndErrStream();
            try {
                File file = new File(directory.getPath());
                byte[] array = new byte[(int)file.length()];
                ByteArrayOutputStream out = new ByteArrayOutputStream(array.length);
                try (FileInputStream in = new FileInputStream(file);){
                    int length = ((InputStream)in).read(array);
                    while (length > 0) {
                        out.write(array, 0, length);
                        length = ((InputStream)in).read(array);
                    }
                }
                ClassReader reader = new ClassReader(array);
                String className = reader.getClassName();
                Class<?> clazz = Class.forName(className.replace('/', '.'), true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                LoggingUtils.restorePreviousOutAndErrStream();
                if (CoverageAnalysis.isTest(clazz)) {
                    testClasses.add(clazz);
                }
            }
            catch (IllegalAccessError e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Cannot access class " + directory.getName().substring(0, directory.getName().length() - 6) + ": " + e);
            }
            catch (NoClassDefFoundError e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Error while loading " + directory.getName().substring(0, directory.getName().length() - 6) + ": Cannot find " + e.getMessage());
            }
            catch (ExceptionInInitializerError e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Exception in initializer of " + directory.getName().substring(0, directory.getName().length() - 6));
            }
            catch (ClassNotFoundException e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Class not found in classpath: " + directory.getName().substring(0, directory.getName().length() - 6) + ": " + e);
            }
            catch (Throwable e) {
                LoggingUtils.restorePreviousOutAndErrStream();
                System.out.println("  Unexpected error: " + directory.getName().substring(0, directory.getName().length() - 6) + ": " + e);
            }
        } else if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                testClasses.addAll(CoverageAnalysis.getTestClasses(file));
            }
        }
        return testClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> getTestClassesJar(File file) {
        ZipFile zf;
        ArrayList testClasses = new ArrayList();
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            if (!fileName.endsWith(".class")) continue;
            PrintStream old_out = System.out;
            PrintStream old_err = System.err;
            try {
                Class<?> clazz = Class.forName(fileName.replace(".class", "").replace("/", "."), true, TestGenerationContext.getInstance().getClassLoaderForSUT());
                if (!CoverageAnalysis.isTest(clazz)) continue;
                testClasses.add(clazz);
            }
            catch (IllegalAccessError ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Cannot access class " + file.getName().substring(0, file.getName().length() - 6));
            }
            catch (NoClassDefFoundError ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Cannot find dependent class " + ex);
            }
            catch (ExceptionInInitializerError ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Exception in initializer of " + file.getName().substring(0, file.getName().length() - 6));
            }
            catch (ClassNotFoundException ex) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("Cannot find class " + file.getName().substring(0, file.getName().length() - 6) + ": " + ex);
            }
            catch (Throwable t) {
                System.setOut(old_out);
                System.setErr(old_err);
                System.out.println("  Unexpected error: " + file.getName().substring(0, file.getName().length() - 6) + ": " + t);
            }
            finally {
                System.setOut(old_out);
                System.setErr(old_err);
            }
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return testClasses;
    }

    private static void analyzeCoverageCriterion(List<JUnitResult> results, Properties.Criterion criterion) {
        logger.info("analysing coverage of " + (Object)((Object)criterion));
        TestFitnessFactory<? extends TestFitnessFunction> factory = FitnessFunctions.getFitnessFactory(criterion);
        List<Comparable<Mutation>> goals = null;
        goals = criterion == Properties.Criterion.MUTATION || criterion == Properties.Criterion.STRONGMUTATION ? MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getMutants() : factory.getCoverageGoals();
        totalGoals += goals.size();
        TestChromosome dummy = new TestChromosome();
        dummy.setChanged(false);
        ExecutionResult executionResult = new ExecutionResult(dummy.getTestCase());
        boolean[][] coverage_matrix = new boolean[results.size()][goals.size() + 1];
        BitSet covered = new BitSet(goals.size());
        for (int index_test = 0; index_test < results.size(); ++index_test) {
            JUnitResult tR = results.get(index_test);
            ExecutionTrace trace = tR.getExecutionTrace();
            executionResult.setTrace(trace);
            dummy.getTestCase().clearCoveredGoals();
            dummy.setLastExecutionResult(executionResult);
            if (criterion == Properties.Criterion.MUTATION || criterion == Properties.Criterion.STRONGMUTATION) {
                block1: for (Integer mutationID : trace.getTouchedMutants()) {
                    Mutation mutation = MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getMutant(mutationID);
                    if (!goals.contains(mutation)) continue;
                    MutationObserver.activateMutation(mutationID);
                    List<JUnitResult> mutationResults = CoverageAnalysis.executeTests(tR.getJUnitClass());
                    MutationObserver.deactivateMutation();
                    for (JUnitResult mR : mutationResults) {
                        if (mR.getFailureCount() == tR.getFailureCount()) continue;
                        logger.info("Mutation killed: " + mutationID);
                        covered.set(mutation.getId());
                        coverage_matrix[index_test][mutationID.intValue()] = true;
                        continue block1;
                    }
                }
            } else {
                if (criterion == Properties.Criterion.EXCEPTION) {
                    // empty if block
                }
                for (int index_component = 0; index_component < goals.size(); ++index_component) {
                    TestFitnessFunction goal = (TestFitnessFunction)goals.get(index_component);
                    if (goal.isCovered(dummy)) {
                        covered.set(index_component);
                        coverage_matrix[index_test][index_component] = true;
                        continue;
                    }
                    coverage_matrix[index_test][index_component] = false;
                }
            }
            coverage_matrix[index_test][goals.size()] = tR.wasSuccessful();
        }
        totalCoveredGoals += covered.cardinality();
        if (Properties.COVERAGE_MATRIX) {
            CoverageReportGenerator.writeCoverage(coverage_matrix, criterion);
        }
        StringBuilder str = new StringBuilder();
        for (int index_component = 0; index_component < goals.size(); ++index_component) {
            str.append(covered.get(index_component) ? "1" : "0");
        }
        logger.info("* CoverageBitString " + str.toString());
        RuntimeVariable bitStringVariable = CoverageCriteriaAnalyzer.getBitStringVariable(criterion);
        if (goals.isEmpty()) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Coverage of criterion " + (Object)((Object)criterion) + ": 100% (no goals)");
            ClientServices.getInstance().getClientNode().trackOutputVariable(CoverageCriteriaAnalyzer.getCoverageVariable(criterion), 1.0);
            if (bitStringVariable != null) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(bitStringVariable, "1");
            }
        } else {
            double coverage = (double)covered.cardinality() / (double)goals.size();
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Coverage of criterion " + (Object)((Object)criterion) + ": " + NumberFormat.getPercentInstance().format(coverage));
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Number of covered goals: " + covered.cardinality() + " / " + goals.size());
            ClientServices.getInstance().getClientNode().trackOutputVariable(CoverageCriteriaAnalyzer.getCoverageVariable(criterion), coverage);
            if (bitStringVariable != null) {
                ClientServices.getInstance().getClientNode().trackOutputVariable(bitStringVariable, str.toString());
            }
        }
    }

    private static void printReport(List<JUnitResult> results) {
        Iterator<String> it = targetClasses.iterator();
        Properties.Criterion[] criterion = Properties.CRITERION;
        while (it.hasNext()) {
            String targetClass = it.next();
            totalGoals = 0;
            totalCoveredGoals = 0;
            Properties.TARGET_CLASS = targetClass;
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Target class " + Properties.TARGET_CLASS);
            ClientServices.getInstance().getClientNode().updateProperty("TARGET_CLASS", Properties.TARGET_CLASS);
            for (Properties.Criterion c : criterion) {
                Properties.CRITERION = new Properties.Criterion[]{c};
                CoverageAnalysis.analyzeCoverageCriterion(results, c);
            }
            Properties.CRITERION = criterion;
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Total number of covered goals: " + totalCoveredGoals + " / " + totalGoals);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, totalGoals);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Covered_Goals, totalCoveredGoals);
            double coverage = totalGoals == 0 ? 1.0 : (double)totalCoveredGoals / (double)totalGoals;
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Total coverage: " + NumberFormat.getPercentInstance().format(coverage));
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Coverage, coverage);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!it.hasNext()) continue;
            ClientServices.getInstance().getClientNode().flushStatisticsForClassChange();
        }
    }

    private static List<JUnitResult> executeTests(Class<?> ... testClasses) {
        ExecutionTracer.enable();
        ExecutionTracer.setCheckCallerThread(false);
        ExecutionTracer.getExecutionTracer().clear();
        ArrayList<JUnitResult> results = new ArrayList<JUnitResult>();
        for (Class<?> testClass : testClasses) {
            LoggingUtils.getEvoLogger().info("  Executing " + testClass.getSimpleName());
            Thread.currentThread().setContextClassLoader(testClass.getClassLoader());
            JUnitRunner jR = new JUnitRunner(testClass);
            jR.run();
            results.addAll(jR.getTestResults());
        }
        ExecutionTracer.disable();
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Executed " + results.size() + " unit test(s)");
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Tests_Executed, results.size());
        return results;
    }

    public static boolean isTest(Class<?> cls) {
        TestClass tc;
        if (Modifier.isAbstract(cls.getModifiers())) {
            return false;
        }
        try {
            tc = new TestClass(cls);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to analyze class " + cls.getName() + " due to: " + e.toString());
        }
        try {
            ArrayList<FrameworkMethod> methods = new ArrayList<FrameworkMethod>();
            methods.addAll(tc.getAnnotatedMethods(Test.class));
            methods.addAll(tc.getAnnotatedMethods(EvoSuiteTest.class));
            for (FrameworkMethod method : methods) {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                method.validatePublicVoidNoArg(false, errors);
                if (!errors.isEmpty()) continue;
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Class<?> superClass = cls;
        while ((superClass = superClass.getSuperclass()) != null && !superClass.getCanonicalName().equals(Object.class.getCanonicalName())) {
            if (!superClass.getCanonicalName().equals(TestCase.class.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private static void sortTestClasses(List<Class<?>> tests) {
        tests.sort((t0, t1) -> Integer.compare(t1.getName().length(), t0.getName().length()));
    }

    public void run() {
        LoggingUtils.getEvoLogger().info("* Connecting to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        ExternalProcessUtilities util = new ExternalProcessUtilities();
        if (!util.connectToMainProcess()) {
            throw new RuntimeException("Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        }
        CoverageAnalysis.analyzeCoverage();
        util.informSearchIsFinished(null);
    }

    protected static void reset() {
        totalGoals = 0;
        totalCoveredGoals = 0;
        targetClasses.clear();
    }
}

