/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.annotations.EvoSuiteTest;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.classpath.ResourceList;
import org.evosuite.shaded.org.apache.commons.lang3.StringUtils;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.AnnotationNode;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnList;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetermineSUT {
    private static final Logger logger = LoggerFactory.getLogger(DetermineSUT.class);
    private String targetName = "";
    private Set<String> superClasses = new HashSet<String>();

    public String getSUTName(String fullyQualifiedTargetClass, String targetClassPath) throws NoJUnitClassException {
        this.targetName = fullyQualifiedTargetClass;
        try {
            ClassPathHacker.addFile(targetClassPath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Set<String> targetClasses = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(targetClassPath, false);
        HashSet<String> candidateClasses = new HashSet<String>();
        boolean hasJUnit = false;
        try {
            candidateClasses.addAll(this.determineCalledClasses(fullyQualifiedTargetClass, targetClasses));
            hasJUnit = true;
        }
        catch (ClassNotFoundException e) {
            logger.error("Class not found: " + e, e);
            return "";
        }
        catch (NoJUnitClassException e) {
            // empty catch block
        }
        if (!hasJUnit) {
            throw new NoJUnitClassException();
        }
        if (candidateClasses.isEmpty()) {
            return "<UNKNOWN>";
        }
        ArrayList<String> sortedNames = new ArrayList<String>(candidateClasses);
        sortedNames.sort(new TargetClassSorter(fullyQualifiedTargetClass));
        return (String)sortedNames.get(0);
    }

    public Set<String> determineCalledClasses(String fullyQualifiedTargetClass, Set<String> targetClasses) throws ClassNotFoundException, NoJUnitClassException {
        HashSet<String> calledClasses = new HashSet<String>();
        String className = fullyQualifiedTargetClass.replace('.', '/');
        try {
            InputStream is = ClassLoader.getSystemResourceAsStream(className + ".class");
            if (is == null) {
                throw new ClassNotFoundException("Class '" + className + ".class' should be in target project, but could not be found!");
            }
            ClassReader reader = new ClassReader(is);
            ClassNode classNode = new ClassNode();
            reader.accept(classNode, 4);
            this.superClasses = this.getSuperClasses(classNode);
            if (!this.isJUnitTest(classNode)) {
                throw new NoJUnitClassException();
            }
            this.handleClassNode(calledClasses, classNode, targetClasses);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        calledClasses.remove("java.lang.Object");
        calledClasses.remove(fullyQualifiedTargetClass);
        return calledClasses;
    }

    private void handleClassNode(Set<String> calledClasses, ClassNode cn, Set<String> targetClasses) throws IOException {
        List<MethodNode> methods = cn.methods;
        for (MethodNode mn : methods) {
            this.handleMethodNode(calledClasses, cn, mn, targetClasses);
        }
    }

    public static boolean isJavaClass(String classNameWithDots) {
        return classNameWithDots.startsWith("java.") || classNameWithDots.startsWith("javax.") || classNameWithDots.startsWith("sun.") || classNameWithDots.startsWith("apple.") || classNameWithDots.startsWith("com.apple.");
    }

    private boolean isValidClass(String name) throws IOException {
        if (DetermineSUT.isJavaClass(name)) {
            return false;
        }
        if (name.startsWith("junit")) {
            return false;
        }
        if (name.startsWith("org.junit")) {
            return false;
        }
        if (name.startsWith(this.targetName)) {
            return false;
        }
        if (this.superClasses.contains(name)) {
            return false;
        }
        ClassNode sutNode = this.loadClassNode(name);
        return !this.isJUnitTest(sutNode);
    }

    private void handleMethodNode(Set<String> calledClasses, ClassNode cn, MethodNode mn, Set<String> targetClasses) throws IOException {
        InsnList instructions = mn.instructions;
        for (AbstractInsnNode insn : instructions) {
            String name;
            if (!(insn instanceof MethodInsnNode) || !targetClasses.contains(name = ResourceList.getClassNameFromResourcePath(((MethodInsnNode)insn).owner)) || !this.isValidClass(name)) continue;
            calledClasses.add(name);
        }
    }

    private boolean isJUnitTest(ClassNode cn) throws IOException {
        if ((cn.access & 0x400) == 1024) {
            return false;
        }
        if (this.hasJUnitSuperclass(cn)) {
            return true;
        }
        List<MethodNode> methods = cn.methods;
        for (MethodNode mn : methods) {
            List<AnnotationNode> annotations = mn.visibleAnnotations;
            if (annotations == null) continue;
            for (AnnotationNode an : annotations) {
                if (!an.desc.equals("Lorg/junit/Test;") && !an.desc.equals("L" + PackageInfo.getNameWithSlash(EvoSuiteTest.class) + ";")) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getSuperClasses(ClassNode cn) throws IOException {
        HashSet<String> superClasses = new HashSet<String>();
        String currentSuper = cn.superName;
        while (!currentSuper.equals("java/lang/Object")) {
            superClasses.add(ResourceList.getClassNameFromResourcePath(currentSuper));
            ClassNode superNode = this.loadClassNode(currentSuper);
            currentSuper = superNode.superName;
        }
        return superClasses;
    }

    private boolean hasJUnitSuperclass(ClassNode cn) throws IOException {
        if (cn.superName.equals("java/lang/Object")) {
            return false;
        }
        if (cn.superName.equals("junit/framework/TestCase")) {
            return true;
        }
        ClassNode superClass = this.loadClassNode(cn.superName);
        return this.hasJUnitSuperclass(superClass);
    }

    private ClassNode loadClassNode(String className) throws IOException {
        ClassReader reader = new ClassReader(ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(className));
        ClassNode cn = new ClassNode();
        reader.accept(cn, 4);
        return cn;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Expected parameters: <TestCase> <Target Classpath>");
            return;
        }
        Properties.getInstanceSilent();
        DetermineSUT det = new DetermineSUT();
        try {
            System.out.println(det.getSUTName(args[0], args[1]));
        }
        catch (NoJUnitClassException e) {
            System.err.println("Found no JUnit test case");
        }
    }

    private class TargetClassSorter
    implements Comparator<String> {
        private final String targetClass;

        public TargetClassSorter(String target) {
            this.targetClass = target;
        }

        @Override
        public int compare(String arg0, String arg1) {
            double distance1 = StringUtils.getLevenshteinDistance(this.targetClass, arg0);
            double distance2 = StringUtils.getLevenshteinDistance(this.targetClass, arg1);
            return Double.compare(distance1, distance2);
        }
    }

    public static class NoJUnitClassException
    extends Exception {
        private static final long serialVersionUID = -7035856440476749976L;
    }
}

