/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.util.List;
import java.util.Map;
import org.evosuite.junit.UnitTestAdapter;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;

public class JUnit3TestAdapter
implements UnitTestAdapter {
    @Override
    public String getImports() {
        return "import junit.framework.TestCase;\n";
    }

    @Override
    public String getClassDefinition(String testName) {
        return "public class " + testName + " extends TestCase";
    }

    @Override
    public String getMethodDefinition(String testName) {
        return "public void " + testName + "() ";
    }

    @Override
    public String getSuite(List<String> suites) {
        StringBuilder builder = new StringBuilder();
        builder.append("import junit.framework.Test;\n");
        builder.append("import junit.framework.TestCase;\n");
        builder.append("import junit.framework.TestSuite;\n\n");
        for (String suite : suites) {
            builder.append("import ");
            builder.append(suite);
            builder.append(";\n");
        }
        builder.append("\n");
        builder.append(this.getClassDefinition("GeneratedTestSuite"));
        builder.append(" {\n");
        builder.append("  public static Test suite() {\n");
        builder.append("    TestSuite suite = new TestSuite();\n");
        for (String suite : suites) {
            builder.append("    suite.addTestSuite(");
            builder.append(suite.substring(suite.lastIndexOf(".") + 1));
            builder.append(".class);\n");
        }
        builder.append("    return suite;\n");
        builder.append("  }\n");
        builder.append("}\n");
        return builder.toString();
    }

    @Override
    public String getTestString(int id, TestCase test, Map<Integer, Throwable> exceptions) {
        return test.toCode(exceptions);
    }

    @Override
    public String getTestString(int id, TestCase test, Map<Integer, Throwable> exceptions, TestCodeVisitor visitor) {
        visitor.setExceptions(exceptions);
        test.accept(visitor);
        visitor.clearExceptions();
        return visitor.getCode();
    }
}

