/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import org.evosuite.junit.JUnitResult;
import org.evosuite.junit.JUnitRunner;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.utils.LoggingUtils;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitRunListener
extends RunListener {
    private JUnitRunner junitRunner = null;
    private JUnitResult testResult = null;
    private long start;

    public JUnitRunListener(JUnitRunner jR) {
        this.junitRunner = jR;
    }

    @Override
    public void testRunStarted(Description description) {
        LoggingUtils.getEvoLogger().info("* Number of test cases to execute: " + description.testCount());
    }

    @Override
    public void testRunFinished(Result result) {
        LoggingUtils.getEvoLogger().info("* Number of test cases executed: " + result.getRunCount());
    }

    @Override
    public void testStarted(Description description) {
        LoggingUtils.getEvoLogger().info("* Started: ClassName: " + description.getClassName() + ", MethodName: " + description.getMethodName());
        this.start = System.nanoTime();
        this.testResult = new JUnitResult(description.getClassName() + "#" + description.getMethodName(), this.junitRunner.getJUnitClass());
    }

    @Override
    public void testFinished(Description description) {
        LoggingUtils.getEvoLogger().info("* Finished: ClassName: " + description.getClassName() + ", MethodName: " + description.getMethodName());
        this.testResult.setRuntime(System.nanoTime() - this.start);
        this.testResult.setExecutionTrace(ExecutionTracer.getExecutionTracer().getTrace());
        this.testResult.incrementRunCount();
        ExecutionTracer.getExecutionTracer().clear();
        this.junitRunner.addResult(this.testResult);
    }

    @Override
    public void testFailure(Failure failure) {
        LoggingUtils.getEvoLogger().info("* Failure: " + failure.getMessage());
        for (StackTraceElement s : failure.getException().getStackTrace()) {
            LoggingUtils.getEvoLogger().info("   " + s.toString());
        }
        this.testResult.setSuccessful(false);
        this.testResult.setTrace(failure.getTrace());
        this.testResult.incrementFailureCount();
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        LoggingUtils.getEvoLogger().info("* Ignored: ClassName: " + description.getClassName() + ", MethodName: " + description.getMethodName());
    }
}

