/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationAnalysisRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(MutationAnalysisRunner.class);
    private Set<Mutation> killedMutants = new LinkedHashSet<Mutation>();
    private Set<Mutation> liveMutants;

    public MutationAnalysisRunner(Class<?> klass, Collection<Mutation> allMutants) throws InitializationError {
        super(klass);
        this.liveMutants = new LinkedHashSet<Mutation>(allMutants);
    }

    public MutationAnalysisRunner(Class<?> klass) throws InitializationError {
        this(klass, MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getMutants());
    }

    public Set<Mutation> getLiveMutants() {
        return this.liveMutants;
    }

    public Set<Mutation> getKilledMutants() {
        return this.killedMutants;
    }

    @Override
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        logger.info("Running method " + method.getName());
        SimpleRunListener resultListener = new SimpleRunListener();
        notifier.addListener(resultListener);
        ExecutionTracer.enable();
        super.runChild(method, notifier);
        boolean result = resultListener.hasFailure;
        logger.info("Result without mutant: " + result);
        if (result) {
            logger.info("Failure: " + resultListener.lastFailure.getMessage());
        }
        Set<Integer> touchedMutants = ExecutionTracer.getExecutionTracer().getTrace().getTouchedMutants();
        logger.info("Touched mutants: " + touchedMutants.size());
        for (Integer mutantID : touchedMutants) {
            Mutation m = MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getMutant(mutantID);
            if (this.killedMutants.contains(m)) continue;
            ExecutionTracer.getExecutionTracer().clear();
            resultListener.hasFailure = false;
            MutationObserver.activateMutation(m);
            super.runChild(method, notifier);
            MutationObserver.deactivateMutation(m);
            if (resultListener.hasFailure == result) continue;
            logger.info("Now killed: " + mutantID);
            try {
                this.liveMutants.remove(m);
            }
            catch (Throwable t) {
                logger.info("Error: " + t);
                t.printStackTrace();
            }
            try {
                this.killedMutants.add(m);
            }
            catch (Throwable t) {
                logger.info("Error: " + t);
                t.printStackTrace();
            }
        }
        notifier.removeListener(resultListener);
        logger.info("Done with " + method.getName());
    }

    private static class SimpleRunListener
    extends RunListener {
        public boolean hasFailure = false;
        public Failure lastFailure = null;

        private SimpleRunListener() {
        }

        @Override
        public void testFailure(Failure failure) throws Exception {
            this.hasFailure = true;
            this.lastFailure = failure;
            super.testFailure(failure);
        }
    }
}

