/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.lm;

import org.evosuite.lm.Chromosome;
import org.evosuite.lm.LanguageModelSearch;
import org.evosuite.testcase.ValueMinimizer;
import org.evosuite.testcase.variable.ConstantValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageModel11EA
extends LanguageModelSearch {
    protected static Logger logger = LoggerFactory.getLogger(LanguageModel11EA.class);

    public LanguageModel11EA(ConstantValue statement, ValueMinimizer.Minimization objective) {
        super(objective, statement);
    }

    @Override
    public String optimise() {
        if (this.startPoint == null || this.startPoint.isEmpty()) {
            logger.info("Not trying to optimise null or empty string");
            return this.startPoint;
        }
        this.resetEvaluationCounter();
        Chromosome best = new Chromosome(this.startPoint);
        best.setFitness(this.evaluate(best));
        double originalStringScore = best.getFitness();
        for (int generation = 0; generation < 1000000 && !this.isBudgetExpended(); ++generation) {
            double currentStringScore = best.getFitness();
            Chromosome mutant = this.mutate(best);
            if (!mutant.isEvaluated()) {
                mutant.setFitness(this.evaluate(mutant));
            }
            if (mutant.compareTo(best) <= 0) continue;
            best = mutant;
        }
        double thisStringScore = best.getFitness();
        return best.getValue();
    }
}

