/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.lm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.evosuite.lm.Chromosome;
import org.evosuite.lm.EvaluationBudgetExpendedException;
import org.evosuite.lm.LanguageModelSearch;
import org.evosuite.testcase.ValueMinimizer;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageModelGA
extends LanguageModelSearch {
    private static final int TOURNAMENT_SIZE = 7;
    private static final double MUTATION_RATE = 0.15;
    private static final double CROSSOVER_RATE = 0.8;
    private static final double ELITIST_RATE = 0.3;
    private static final double REFILL_LEVEL = 1.0;
    private HashSet<Chromosome> population = new HashSet();
    private static int POPULATION_SIZE = 20;
    private static final Logger logger = LoggerFactory.getLogger(LanguageModelGA.class);

    public LanguageModelGA(ConstantValue constantValue, ValueMinimizer.Minimization objective) {
        super(objective, constantValue);
        this.setupPopulation();
    }

    private void setupPopulation() {
        Chromosome originalValue = new Chromosome(this.startPoint);
        this.population.add(originalValue);
        while (this.population.size() < POPULATION_SIZE - 1) {
            this.population.add(this.mutate(originalValue));
        }
    }

    private Chromosome select() {
        return this.select(this.population, true);
    }

    private Chromosome select(HashSet<Chromosome> pool) {
        return this.select(pool, true);
    }

    private Chromosome select(HashSet<Chromosome> pool, boolean best) {
        ArrayList<Chromosome> sample = new ArrayList<Chromosome>();
        while (sample.size() < 7 && sample.size() < pool.size()) {
            sample.add(Randomness.choice(pool));
        }
        assert (!sample.isEmpty());
        if (best) {
            sample.sort(Collections.reverseOrder(this));
            return (Chromosome)sample.get(0);
        }
        sample.sort(this);
        return (Chromosome)sample.get(0);
    }

    private HashSet<Chromosome> generation(HashSet<Chromosome> newPopulation) {
        int numMutants = 0;
        int numCrossovers = 0;
        int numElites = 0;
        for (int crossover = 0; crossover < this.population.size(); ++crossover) {
            Object parent2;
            Chromosome parent1;
            if (!(Randomness.nextDouble() < 0.8) || (parent1 = this.select()) == (parent2 = this.select()) || !newPopulation.addAll(this.crossover(parent1, (Chromosome)parent2))) continue;
            ++numCrossovers;
        }
        int numElitesToSelect = (int)Math.round(0.3 * (double)this.population.size());
        ArrayList<Chromosome> rankedPopulation = new ArrayList<Chromosome>(this.population.size());
        rankedPopulation.addAll(this.population);
        rankedPopulation.sort(Collections.reverseOrder(this));
        for (Chromosome elite : rankedPopulation) {
            if (numElitesToSelect <= 0) break;
            if (!newPopulation.add(elite)) continue;
            ++numElites;
            --numElitesToSelect;
        }
        for (int mutant = 0; mutant < this.population.size(); ++mutant) {
            if (!(Randomness.nextDouble() < 0.15) || !newPopulation.add(this.mutate(this.select(newPopulation)))) continue;
            ++numMutants;
        }
        if (newPopulation.size() > POPULATION_SIZE) {
            logger.debug("Removing some weak individuals from old population");
        }
        int numRemoved = 0;
        while (newPopulation.size() > POPULATION_SIZE) {
            Chromosome item = this.select(newPopulation, false);
            assert (item != null);
            assert (newPopulation.contains(item));
            newPopulation.remove(item);
            ++numRemoved;
        }
        int numAdded = 0;
        if ((double)newPopulation.size() < (double)POPULATION_SIZE * 1.0) {
            HashSet<Chromosome> oldPopulation = new HashSet<Chromosome>(this.population);
            logger.debug("Pulling individuals from old population (size = {})", (Object)newPopulation.size());
            while ((double)newPopulation.size() < (double)POPULATION_SIZE * 1.0 && !oldPopulation.isEmpty()) {
                Chromosome individual = Randomness.choice(oldPopulation);
                oldPopulation.remove(individual);
                if (!newPopulation.add(individual)) continue;
                ++numAdded;
            }
            if ((double)newPopulation.size() < (double)POPULATION_SIZE * 1.0) {
                logger.debug("Adding random mutants to keep pop size up (current size is {})", (Object)newPopulation.size());
            }
            while ((double)newPopulation.size() < (double)POPULATION_SIZE * 1.0 && !this.population.isEmpty()) {
                newPopulation.add(this.mutate(Randomness.choice(this.population)));
            }
        }
        logger.debug("Finished a GA generation. Created {} mutants, performed {} crossovers and preserved {} elites on a population of {} (-{},+{}) New pop: {}", numMutants, numCrossovers, numElites, this.population.size(), numRemoved, numAdded, newPopulation.size());
        return newPopulation;
    }

    protected Chromosome getBest(HashSet<Chromosome> population, Chromosome best) {
        for (Chromosome individual : population) {
            try {
                if (individual.compareTo(best) <= 0) continue;
                best = individual;
            }
            catch (EvaluationBudgetExpendedException e) {
                logger.debug("Evaluation limit hit by GA; will select best from evaluated population.");
                break;
            }
        }
        return best;
    }

    @Override
    public String optimise() {
        this.resetEvaluationCounter();
        Chromosome best = this.getBest(this.population, null);
        for (int generation = 0; generation < 1000000 && !this.isBudgetExpended(); ++generation) {
            HashSet<Chromosome> newPopulation = new HashSet<Chromosome>();
            try {
                this.generation(newPopulation);
                if (newPopulation.isEmpty()) {
                    assert (this.isBudgetExpended());
                    throw new RuntimeException("LM GA: New population is empty");
                }
            }
            catch (EvaluationBudgetExpendedException e) {
                logger.debug("Couldn't finish a generation, ran out of evaluations.");
            }
            logger.debug("LM GA: Generation {} of {}. Population size is {} (previously {}). Best fitness is [{}], fitness: {}", generation, 1000000, newPopulation.size(), this.population.size(), best.getValue(), best.getFitness());
            this.population = newPopulation;
            best = this.getBest(this.population, best);
        }
        return best.getValue();
    }

    protected List<? extends Chromosome> crossover(Chromosome parent1, Chromosome parent2) {
        String p1 = parent1.getValue();
        String p2 = parent2.getValue();
        int splitPoint = Randomness.nextInt(0, p1.length());
        String c1 = p1.substring(0, splitPoint) + p2.substring(splitPoint);
        String c2 = p2.substring(0, splitPoint) + p1.substring(splitPoint);
        Chromosome child1 = new Chromosome(c1);
        Chromosome child2 = new Chromosome(c2);
        return Arrays.asList(child1, child2);
    }
}

