/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.novelty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class SuiteFitnessEvaluationListener
implements SearchListener<TestChromosome> {
    private static final long serialVersionUID = 3871230464292232335L;
    private final List<TestSuiteFitnessFunction> fitnessFunctions;

    public SuiteFitnessEvaluationListener(List<TestSuiteFitnessFunction> fitnessFunctions) {
        this.fitnessFunctions = new ArrayList<TestSuiteFitnessFunction>(fitnessFunctions);
    }

    public SuiteFitnessEvaluationListener(SuiteFitnessEvaluationListener that) {
        this(that.fitnessFunctions);
    }

    private TestSuiteChromosome createMergedSolution(Collection<TestChromosome> population) {
        TestSuiteChromosome suite = new TestSuiteChromosome();
        suite.addTests(population);
        return suite;
    }

    public TestSuiteChromosome getSuiteWithFitness(GeneticAlgorithm<TestChromosome> algorithm) {
        List<TestChromosome> population = algorithm.getPopulation();
        TestSuiteChromosome suite = this.createMergedSolution(population);
        for (TestSuiteFitnessFunction fitnessFunction : this.fitnessFunctions) {
            fitnessFunction.getFitness(suite);
        }
        return suite;
    }

    @Override
    public void iteration(GeneticAlgorithm<TestChromosome> algorithm) {
        this.getSuiteWithFitness(algorithm);
        algorithm.updateFitnessFunctionsAndValues();
    }

    @Override
    public void searchStarted(GeneticAlgorithm<TestChromosome> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<TestChromosome> algorithm) {
    }

    @Override
    public void fitnessEvaluation(TestChromosome individual) {
    }

    @Override
    public void modification(TestChromosome individual) {
    }
}

