/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.result;

import java.io.Serializable;
import org.evosuite.coverage.branch.Branch;

public class BranchInfo
implements Serializable {
    private static final long serialVersionUID = -2145547942894978737L;
    private String className;
    private String methodName;
    private int lineNo;
    private boolean truthValue;

    public BranchInfo(Branch branch, boolean truthValue) {
        this.className = branch.getClassName();
        this.methodName = branch.getMethodName();
        this.lineNo = branch.getInstruction().getLineNumber();
        this.truthValue = truthValue;
    }

    public BranchInfo(String className, String methodName, int lineNo, boolean truthValue) {
        this.className = className;
        this.methodName = methodName;
        this.lineNo = lineNo;
        this.truthValue = truthValue;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public boolean getTruthValue() {
        return this.truthValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + this.lineNo;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.truthValue ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BranchInfo other = (BranchInfo)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.lineNo != other.lineNo) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return this.truthValue == other.truthValue;
    }

    public String toString() {
        return "BranchInfo [className=" + this.className + ", methodName=" + this.methodName + ", lineNo=" + this.lineNo + ", truthValue=" + this.truthValue + "]";
    }
}

