/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.result;

import java.io.Serializable;
import org.evosuite.coverage.mutation.Mutation;

public class MutationInfo
implements Serializable {
    private static final long serialVersionUID = 4580001065523289191L;
    private String className;
    private String methodName;
    int lineNo;
    private String replacement;

    public MutationInfo(Mutation m) {
        this.className = m.getClassName();
        this.methodName = m.getMethodName();
        this.lineNo = m.getLineNumber();
        this.replacement = m.getMutationName();
    }

    public MutationInfo(String className, String methodName, int lineNo, String replacement) {
        this.className = className;
        this.methodName = methodName;
        this.lineNo = lineNo;
        this.replacement = replacement;
    }

    public String getClassName() {
        return this.className;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + this.lineNo;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutationInfo other = (MutationInfo)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.lineNo != other.lineNo) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement));
    }

    public String toString() {
        return "MutationInfo [className=" + this.className + ", methodName=" + this.methodName + ", lineNo=" + this.lineNo + ", replacement=" + this.replacement + "]";
    }
}

