/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.evosuite.runtime.InitializingListenerUtils;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.agent.InstrumentingAgent;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class InitializingListener
extends RunListener {
    public static final String INITIALIZE_CLASSES_METHOD = "initializeClasses";
    public static final String SCAFFOLDING_LIST_FILE_STRING = ".scaffolding_list.tmp";
    public static final String COMPILED_TESTS_FOLDER_PROPERTY = "EvoSuiteCompiledTestFolder";

    public static String getScaffoldingListFilePath() {
        return SCAFFOLDING_LIST_FILE_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testRunStarted(Description description) throws Exception {
        System.out.println("Executing " + InitializingListener.class.getName());
        RuntimeSettings.activateAllMocking();
        RuntimeSettings.mockSystemIn = true;
        RuntimeSettings.resetStaticState = true;
        String compiledTestsFolder = System.getProperty(COMPILED_TESTS_FOLDER_PROPERTY);
        List<String> list = compiledTestsFolder == null ? this.classesToInitFromScaffoldingFile() : InitializingListenerUtils.scanClassesToInit(new File(compiledTestsFolder));
        InstrumentingAgent.initialize();
        for (String name : list) {
            Method m = null;
            try {
                InstrumentingAgent.activate();
                Class<?> test = InitializingListener.class.getClassLoader().loadClass(name);
                m = test.getDeclaredMethod(INITIALIZE_CLASSES_METHOD, new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException test) {
            }
            catch (Exception e) {
                System.out.println("Exception while loading class " + name + ": " + e.getMessage());
            }
            finally {
                InstrumentingAgent.deactivate();
            }
            if (m == null) continue;
            try {
                m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Exception while calling " + name + "." + INITIALIZE_CLASSES_METHOD + "(): " + e.getMessage());
            }
        }
    }

    private List<String> classesToInitFromScaffoldingFile() {
        ArrayList<String> list = new ArrayList<String>();
        File scaffolding = new File(SCAFFOLDING_LIST_FILE_STRING);
        if (!scaffolding.exists()) {
            System.out.println("WARN: scaffolding file not found. If this module has tests, recall to call the preparation step before executing the tests. For example, in Maven you need to make sure that 'evosuite:prepare' is called. See documentation at www.evosuite.org for further details.");
            return list;
        }
        try (Scanner in = new Scanner(scaffolding);){
            while (in.hasNext()) {
                list.add(in.next().trim());
            }
        }
        catch (Exception e) {
            System.out.println("ERROR while reading scaffolding list file: " + e.getMessage());
        }
        return list;
    }
}

