/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import java.util.Arrays;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.System;
import org.evosuite.runtime.annotation.EvoSuiteExclude;
import org.evosuite.runtime.instrumentation.InstrumentedClass;
import org.evosuite.runtime.instrumentation.MethodCallReplacementMethodAdapter;
import org.evosuite.runtime.instrumentation.RegisterObjectForDeterministicHashCodeVisitor;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.runtime.mock.StaticReplacementMock;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.evosuite.shaded.org.objectweb.asm.FieldVisitor;
import org.evosuite.shaded.org.objectweb.asm.MethodVisitor;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.shaded.org.objectweb.asm.commons.GeneratorAdapter;
import org.evosuite.shaded.org.objectweb.asm.commons.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCallReplacementClassAdapter
extends ClassVisitor {
    private final String className;
    private String superClassName;
    private boolean definesHashCode = false;
    private boolean isInterface = false;
    private boolean definesUid = false;
    private boolean canChangeSignature = true;
    private static final Logger logger = LoggerFactory.getLogger(MethodCallReplacementClassAdapter.class);

    public MethodCallReplacementClassAdapter(ClassVisitor cv, String className) {
        this(cv, className, true);
    }

    public MethodCallReplacementClassAdapter(ClassVisitor cv, String className, boolean canAddMethods) {
        super(589824, cv);
        this.className = className;
        this.superClassName = null;
        this.canChangeSignature = canAddMethods;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("hashCode")) {
            this.definesHashCode = true;
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<init>")) {
            mv = new RegisterObjectForDeterministicHashCodeVisitor(mv, access, name, desc);
        }
        return new MethodCallReplacementMethodAdapter(mv, this.className, this.superClassName, name, access, desc);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("serialVersionUID")) {
            this.definesUid = true;
            if (this.isInterface) {
                return super.visitField(25, name, desc, signature, value);
            }
            return super.visitField(26, name, desc, signature, value);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String superNameWithDots;
        this.superClassName = superNameWithDots = superName.replace('/', '.');
        if ((access & 0x200) == 512) {
            this.isInterface = true;
        } else {
            boolean found = false;
            String instrumentedInterface = InstrumentedClass.class.getCanonicalName().replace('.', '/');
            for (String interf : interfaces) {
                if (!interf.equals(instrumentedInterface)) continue;
                found = true;
            }
            if (!found) {
                logger.info("Adding mock interface to class " + name);
                String[] mockedInterfaces = Arrays.copyOf(interfaces, interfaces.length + 1);
                mockedInterfaces[interfaces.length] = InstrumentedClass.class.getCanonicalName().replace('.', '/');
                interfaces = mockedInterfaces;
            }
        }
        if (MockList.shouldBeMocked(superNameWithDots)) {
            Class<?> mockSuperClass = MockList.getMockClass(superNameWithDots);
            if (StaticReplacementMock.class.isAssignableFrom(mockSuperClass)) {
                super.visit(version, access, name, signature, superName, interfaces);
            } else {
                String mockSuperClassName = mockSuperClass.getCanonicalName().replace('.', '/');
                super.visit(version, access, name, signature, mockSuperClassName, interfaces);
            }
        } else {
            super.visit(version, access, name, signature, superName, interfaces);
        }
    }

    @Override
    public void visitEnd() {
        if (this.canChangeSignature && !this.definesHashCode && !this.isInterface && RuntimeSettings.mockJVMNonDeterminism && this.superClassName.equals("java.lang.Object")) {
            Method hashCodeMethod = Method.getMethod("int hashCode()");
            GeneratorAdapter mg = new GeneratorAdapter(1, hashCodeMethod, null, null, this);
            mg.loadThis();
            mg.visitAnnotation(Type.getDescriptor(EvoSuiteExclude.class), true);
            mg.invokeStatic(Type.getType(System.class), Method.getMethod("int identityHashCode(Object)"));
            mg.returnValue();
            mg.endMethod();
        }
        super.visitEnd();
    }
}

