/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.instrumentation;

import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.instrumentation.AnnotatedClassNode;
import org.evosuite.runtime.instrumentation.CreateClassResetClassAdapter;
import org.evosuite.runtime.instrumentation.ExcludedClasses;
import org.evosuite.runtime.instrumentation.InstrumentedClass;
import org.evosuite.runtime.instrumentation.JSRInlinerClassVisitor;
import org.evosuite.runtime.instrumentation.KillSwitchClassAdapter;
import org.evosuite.runtime.instrumentation.LoopCounterClassAdapter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementClassAdapter;
import org.evosuite.runtime.instrumentation.RemoveFinalClassAdapter;
import org.evosuite.runtime.util.ComputeClassWriter;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.ClassVisitor;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInstrumentation {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeInstrumentation.class);
    private volatile boolean retransformingMode = false;
    private static boolean avoidInstrumentingShadedClasses = false;

    public void setRetransformingMode(boolean on) {
        this.retransformingMode = on;
    }

    public static void setAvoidInstrumentingShadedClasses(boolean avoidInstrumentingShadedClasses) {
        RuntimeInstrumentation.avoidInstrumentingShadedClasses = avoidInstrumentingShadedClasses;
    }

    public static boolean getAvoidInstrumentingShadedClasses() {
        return avoidInstrumentingShadedClasses;
    }

    public static boolean checkIfCanInstrument(String className) {
        for (String s : ExcludedClasses.getPackagesShouldNotBeInstrumented()) {
            if (!className.startsWith(s)) continue;
            return false;
        }
        if (className.contains("EnhancerByMockito")) {
            return false;
        }
        return !className.contains("__CLR");
    }

    public boolean isAlreadyInstrumented(ClassReader reader) {
        ClassNode classNode = new ClassNode();
        int readFlags = 5;
        reader.accept(classNode, readFlags);
        for (String interfaceName : classNode.interfaces) {
            if (!InstrumentedClass.class.getName().equals(interfaceName.replace('/', '.'))) continue;
            return true;
        }
        return false;
    }

    public byte[] transformBytes(ClassLoader classLoader, String className, ClassReader reader, boolean skipInstrumentation) {
        ComputeClassWriter writer;
        String classNameWithDots = className.replace('/', '.');
        if (!RuntimeInstrumentation.checkIfCanInstrument(classNameWithDots)) {
            throw new IllegalArgumentException("Should not transform a shared class (" + classNameWithDots + ")! Load by parent (JVM) classloader.");
        }
        int asmFlags = 2;
        ClassVisitor cv = writer = new ComputeClassWriter(asmFlags);
        if (!skipInstrumentation) {
            if (RuntimeSettings.resetStaticState && !this.retransformingMode) {
                CreateClassResetClassAdapter resetClassAdapter = new CreateClassResetClassAdapter(cv, className, true);
                cv = resetClassAdapter;
            }
            if (RuntimeSettings.isUsingAnyMocking()) {
                cv = new MethodCallReplacementClassAdapter(cv, className, !this.retransformingMode);
            }
            cv = new KillSwitchClassAdapter(cv);
            cv = new RemoveFinalClassAdapter(cv);
            if (RuntimeSettings.maxNumberOfIterationsPerLoop >= 0L) {
                cv = new LoopCounterClassAdapter(cv);
            }
        }
        AnnotatedClassNode cn = new AnnotatedClassNode();
        int readFlags = 4;
        reader.accept(cn, readFlags);
        cv = new JSRInlinerClassVisitor(cv);
        try {
            cn.accept(cv);
        }
        catch (Throwable ex) {
            logger.error("Error while instrumenting class " + className + ": " + ex.getMessage(), ex);
        }
        return writer.toByteArray();
    }
}

