/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.io.MockIOException;
import org.evosuite.runtime.mock.java.lang.MockIllegalArgumentException;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.vfs.FSObject;
import org.evosuite.runtime.vfs.VFile;
import org.evosuite.runtime.vfs.VFolder;
import org.evosuite.runtime.vfs.VirtualFileSystem;

public class MockFile
extends File
implements OverrideMock {
    private static final long serialVersionUID = -8217763202925800733L;

    public MockFile(String pathname) {
        super(pathname);
    }

    public MockFile(String parent, String child) {
        this(MockFile.combine(parent, child));
    }

    public MockFile(File parent, String child) {
        this(parent == null ? null : parent.getAbsolutePath(), child);
    }

    public MockFile(URI uri) {
        super(uri);
    }

    private static String combine(String parent, String child) {
        if (child == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            return child;
        }
        if (parent.equals("")) {
            return VirtualFileSystem.getDefaultParent() + child;
        }
        return MockFile.makeAbsolute(parent) + "/" + child;
    }

    private static String makeAbsolute(String path) {
        String base = VirtualFileSystem.getWorkingDirPath();
        if (base.startsWith("/")) {
            if (path.startsWith("/")) {
                return path;
            }
            return base + "/" + path;
        }
        String root = base.substring(0, 3);
        if (path.startsWith(root)) {
            return path;
        }
        return base + "/" + path;
    }

    public static File[] listRoots() {
        if (!MockFramework.isEnabled()) {
            return File.listRoots();
        }
        File[] roots = File.listRoots();
        File[] mocks = new MockFile[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            mocks[i] = new MockFile(roots[i].getAbsolutePath());
        }
        return mocks;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (!MockFramework.isEnabled()) {
            return File.createTempFile(prefix, suffix, directory);
        }
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded("");
        String path = VirtualFileSystem.getInstance().createTempFile(prefix, suffix, directory);
        if (path == null) {
            throw new MockIOException();
        }
        return new MockFile(path);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return MockFile.createTempFile(prefix, suffix, null);
    }

    @Override
    public String getAbsolutePath() {
        if (!MockFramework.isEnabled()) {
            return super.getAbsolutePath();
        }
        String absolute = MockFile.makeAbsolute(this.getPath());
        File tmp = new File(absolute);
        return tmp.getAbsolutePath();
    }

    @Override
    public int compareTo(File pathname) {
        if (!MockFramework.isEnabled()) {
            return super.compareTo(pathname);
        }
        return new File(this.getAbsolutePath()).compareTo(pathname);
    }

    @Override
    public File getParentFile() {
        if (!MockFramework.isEnabled()) {
            return super.getParentFile();
        }
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return new MockFile(p);
    }

    @Override
    public File getAbsoluteFile() {
        if (!MockFramework.isEnabled()) {
            return super.getAbsoluteFile();
        }
        String absPath = this.getAbsolutePath();
        return new MockFile(absPath);
    }

    @Override
    public File getCanonicalFile() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.getCanonicalFile();
        }
        String canonPath = this.getCanonicalPath();
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.getAbsolutePath());
        return new MockFile(canonPath);
    }

    @Override
    public boolean canRead() {
        if (!MockFramework.isEnabled()) {
            return super.canRead();
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        return file.isReadPermission();
    }

    @Override
    public boolean setReadOnly() {
        if (!MockFramework.isEnabled()) {
            return super.setReadOnly();
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        file.setReadPermission(true);
        file.setExecutePermission(false);
        file.setWritePermission(false);
        return true;
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        if (!MockFramework.isEnabled()) {
            return super.setReadable(readable, ownerOnly);
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        file.setReadPermission(readable);
        return true;
    }

    @Override
    public boolean canWrite() {
        if (!MockFramework.isEnabled()) {
            return super.canWrite();
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        return file.isWritePermission();
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        if (!MockFramework.isEnabled()) {
            return super.setWritable(writable, ownerOnly);
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        file.setWritePermission(writable);
        return true;
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        if (!MockFramework.isEnabled()) {
            return super.setExecutable(executable, ownerOnly);
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        file.setExecutePermission(executable);
        return true;
    }

    @Override
    public boolean canExecute() {
        if (!MockFramework.isEnabled()) {
            return super.canExecute();
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        return file.isExecutePermission();
    }

    @Override
    public boolean exists() {
        if (!MockFramework.isEnabled()) {
            return super.exists();
        }
        return VirtualFileSystem.getInstance().exists(this.getAbsolutePath());
    }

    @Override
    public boolean isDirectory() {
        if (!MockFramework.isEnabled()) {
            return super.isDirectory();
        }
        FSObject file = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (file == null) {
            return false;
        }
        return file.isFolder();
    }

    @Override
    public boolean isFile() {
        if (!MockFramework.isEnabled()) {
            return super.isFile();
        }
        return !this.isDirectory();
    }

    @Override
    public boolean isHidden() {
        if (!MockFramework.isEnabled()) {
            return super.isHidden();
        }
        return this.getName().startsWith(".");
    }

    @Override
    public boolean setLastModified(long time) {
        if (!MockFramework.isEnabled()) {
            return super.setLastModified(time);
        }
        if (time < 0L) {
            throw new MockIllegalArgumentException("Negative time");
        }
        FSObject target = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (target == null) {
            return false;
        }
        return target.setLastModified(time);
    }

    @Override
    public long lastModified() {
        if (!MockFramework.isEnabled()) {
            return super.lastModified();
        }
        FSObject target = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (target == null) {
            return 0L;
        }
        return target.getLastModified();
    }

    @Override
    public long length() {
        if (!MockFramework.isEnabled()) {
            return super.length();
        }
        FSObject target = VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        if (target == null) {
            return 0L;
        }
        if (target.isFolder() || target.isDeleted()) {
            return 0L;
        }
        VFile file = (VFile)target;
        return file.getDataSize();
    }

    @Override
    public long getTotalSpace() {
        if (!MockFramework.isEnabled()) {
            return super.getTotalSpace();
        }
        return 0L;
    }

    @Override
    public long getFreeSpace() {
        if (!MockFramework.isEnabled()) {
            return super.getFreeSpace();
        }
        return 0L;
    }

    @Override
    public long getUsableSpace() {
        if (!MockFramework.isEnabled()) {
            return super.getUsableSpace();
        }
        return 0L;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.createNewFile();
        }
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.getAbsolutePath());
        return VirtualFileSystem.getInstance().createFile(this.getAbsolutePath());
    }

    @Override
    public boolean delete() {
        if (!MockFramework.isEnabled()) {
            return super.delete();
        }
        return VirtualFileSystem.getInstance().deleteFSObject(this.getAbsolutePath());
    }

    @Override
    public boolean renameTo(File dest) {
        if (!MockFramework.isEnabled()) {
            return super.renameTo(dest);
        }
        boolean renamed = VirtualFileSystem.getInstance().rename(this.getAbsolutePath(), dest.getAbsolutePath());
        return renamed;
    }

    @Override
    public boolean mkdir() {
        if (!MockFramework.isEnabled()) {
            return super.mkdir();
        }
        String parent = this.getParent();
        if (parent == null || !VirtualFileSystem.getInstance().exists(parent)) {
            return false;
        }
        return VirtualFileSystem.getInstance().createFolder(this.getAbsolutePath());
    }

    @Override
    public void deleteOnExit() {
        if (!MockFramework.isEnabled()) {
            super.deleteOnExit();
        }
    }

    @Override
    public String[] list() {
        if (!MockFramework.isEnabled()) {
            return super.list();
        }
        if (!this.isDirectory() || !this.exists()) {
            return null;
        }
        VFolder dir = (VFolder)VirtualFileSystem.getInstance().findFSObject(this.getAbsolutePath());
        return dir.getChildrenNames();
    }

    @Override
    public File[] listFiles() {
        if (!MockFramework.isEnabled()) {
            return super.listFiles();
        }
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        File[] fs = new MockFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new MockFile(this, ss[i]);
        }
        return fs;
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        if (!MockFramework.isEnabled()) {
            return super.listFiles(filter);
        }
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<MockFile> files = new ArrayList<MockFile>();
        for (String s : ss) {
            MockFile f = new MockFile(this, s);
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        if (!MockFramework.isEnabled()) {
            return super.getCanonicalPath();
        }
        VirtualFileSystem.getInstance().throwSimuledIOExceptionIfNeeded(this.getAbsolutePath());
        return super.getCanonicalPath();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        if (!MockFramework.isEnabled() || !RuntimeSettings.useVNET) {
            return super.toURL();
        }
        URL url = super.toURL();
        return MockURL.URL(url.toString());
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getParent() {
        return super.getParent();
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    @Override
    public boolean isAbsolute() {
        return super.isAbsolute();
    }

    @Override
    public URI toURI() {
        return super.toURI();
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return super.list(filter);
    }

    @Override
    public boolean mkdirs() {
        return super.mkdirs();
    }

    @Override
    public boolean setWritable(boolean writable) {
        return super.setWritable(writable);
    }

    @Override
    public boolean setReadable(boolean readable) {
        return super.setReadable(readable);
    }

    @Override
    public boolean setExecutable(boolean executable) {
        return super.setExecutable(executable);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

