/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownHostException;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.runtime.mock.java.net.MockInetAddress;
import org.evosuite.runtime.mock.java.net.URLUtil;

public abstract class MockURLStreamHandler
extends URLStreamHandler
implements OverrideMock {
    @Override
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    @Override
    protected synchronized InetAddress getHostAddress(URL u) {
        if (!MockFramework.isEnabled()) {
            return super.getHostAddress(u);
        }
        if (URLUtil.getHostAddress(u) != null) {
            return URLUtil.getHostAddress(u);
        }
        String host = u.getHost();
        if (host == null || host.equals("")) {
            return null;
        }
        try {
            URLUtil.setHostAddress(u, MockInetAddress.getByName(host));
        }
        catch (UnknownHostException ex) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
        return URLUtil.getHostAddress(u);
    }

    @Override
    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        super.parseURL(u, spec, start, limit);
    }

    @Override
    protected int getDefaultPort() {
        return super.getDefaultPort();
    }

    @Override
    protected boolean equals(URL u1, URL u2) {
        return super.equals(u1, u2);
    }

    @Override
    protected int hashCode(URL u) {
        return super.hashCode(u);
    }

    @Override
    protected boolean sameFile(URL u1, URL u2) {
        return super.sameFile(u1, u2);
    }

    @Override
    protected boolean hostsEqual(URL u1, URL u2) {
        return super.hostsEqual(u1, u2);
    }

    @Override
    protected String toExternalForm(URL u) {
        return super.toExternalForm(u);
    }

    @Override
    protected void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        super.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }

    @Override
    @Deprecated
    protected void setURL(URL u, String protocol, String host, int port, String file, String ref) {
        super.setURL(u, protocol, host, port, file, ref);
    }
}

