/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.mock.java.net;

import java.io.IOException;
import java.io.InputStream;
import org.evosuite.runtime.vnet.NativeTcp;

public class SocketIn
extends InputStream {
    private final NativeTcp tcp;
    private final boolean isLocal;
    private volatile boolean closed;

    public SocketIn(NativeTcp tcp, boolean isLocal) throws IllegalArgumentException {
        if (tcp == null) {
            throw new IllegalArgumentException("Input connection cannot be null");
        }
        this.tcp = tcp;
        this.isLocal = isLocal;
        this.closed = false;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.isLocal) {
            return this.tcp.readInSUTfromRemote();
        }
        return this.tcp.readInTestFromSUT();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        if (this.isLocal) {
            return this.tcp.getAmountOfDataInLocalBuffer();
        }
        return this.tcp.getAmountOfDataInRemoteBuffer();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Closed stream");
        }
    }
}

