/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeClassWriter
extends ClassWriter {
    private final Logger logger = LoggerFactory.getLogger(ComputeClassWriter.class);
    private ClassLoader l = this.getClass().getClassLoader();

    public ComputeClassWriter(int flags) {
        super(flags);
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        try {
            String result;
            block13: {
                ClassReader info2;
                ClassReader info1;
                try {
                    info1 = this.typeInfo(type1);
                }
                catch (NullPointerException e) {
                    throw new RuntimeException("Class not found: " + type1 + ": " + e.toString(), e);
                }
                try {
                    info2 = this.typeInfo(type2);
                }
                catch (NullPointerException e) {
                    throw new RuntimeException("Class not found: " + type2 + ": " + e.toString(), e);
                }
                if ((info1.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type2, info2, type1)) {
                        return type1;
                    }
                    if ((info2.getAccess() & 0x200) != 0 && this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                if ((info2.getAccess() & 0x200) != 0) {
                    if (this.typeImplements(type1, info1, type2)) {
                        return type2;
                    }
                    return "java/lang/Object";
                }
                StringBuilder b1 = this.typeAncestors(type1, info1);
                StringBuilder b2 = this.typeAncestors(type2, info2);
                result = "java/lang/Object";
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(";", end1 - 1);
                    int start2 = b2.lastIndexOf(";", end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block13;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    end1 = start1;
                    end2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return b;
    }

    private boolean typeImplements(String type, ClassReader info, String itf) throws IOException {
        while (!"java/lang/Object".equals(type)) {
            String[] itfs;
            for (String s : itfs = info.getInterfaces()) {
                if (!s.equals(itf)) continue;
                return true;
            }
            for (String s : itfs) {
                if (!this.typeImplements(s, this.typeInfo(s), itf)) continue;
                return true;
            }
            type = info.getSuperName();
            info = this.typeInfo(type);
        }
        return false;
    }

    private ClassReader typeInfo(String type) throws IOException, NullPointerException {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(type + ".class");){
            if (is == null) {
                throw new NullPointerException("Class not found " + type);
            }
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
    }
}

