/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.io.File;
import java.util.Optional;

public class JavaExecCmdUtil {
    private JavaExecCmdUtil() {
    }

    public static String getJavaBinExecutablePath(boolean isFullOriginalJavaExecRequired) {
        String separator = System.getProperty("file.separator");
        String JAVA_CMD = System.getProperty("java.home") + separator + "bin" + separator + "java";
        return JavaExecCmdUtil.getJavaHomeEnv().map(javaHomeEnvVar -> new File(javaHomeEnvVar + File.separatorChar + "bin" + File.separatorChar + "java" + JavaExecCmdUtil.getOsName().filter(osName -> osName.toLowerCase().contains("windows")).map(osName -> ".exe").orElse(""))).filter(File::exists).map(File::getPath).orElse(isFullOriginalJavaExecRequired ? JAVA_CMD : "java");
    }

    public static String getJavaBinExecutablePath() {
        return JavaExecCmdUtil.getJavaBinExecutablePath(false);
    }

    private static Optional<String> getJavaHomeEnv() {
        return Optional.ofNullable(System.getenv("JAVA_HOME"));
    }

    static Optional<String> getOsName() {
        return Optional.ofNullable(System.getProperty("os.name"));
    }
}

