/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.runtime.RuntimeSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInUtil
extends InputStream {
    private static final InputStream defaultIn = System.in;
    private static final Logger logger = LoggerFactory.getLogger(SystemInUtil.class);
    private static final SystemInUtil singleton = new SystemInUtil();
    private volatile boolean beingUsed;
    private volatile List<Byte> data;
    private volatile AtomicInteger counter;
    private static final Object monitor = new Object();
    private volatile boolean endReached;

    protected SystemInUtil() {
    }

    public static synchronized SystemInUtil getInstance() {
        return singleton;
    }

    public static synchronized void resetSingleton() {
        SystemInUtil.singleton.beingUsed = false;
        SystemInUtil.singleton.data = new ArrayList<Byte>();
        SystemInUtil.singleton.counter = new AtomicInteger(0);
        SystemInUtil.singleton.endReached = false;
        System.setIn(defaultIn);
    }

    public void initForTestCase() {
        this.data = new ArrayList<Byte>();
        this.counter = new AtomicInteger(0);
        this.endReached = false;
        if (RuntimeSettings.mockSystemIn) {
            System.setIn(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInputLine(String input) {
        if (input == null) {
            return;
        }
        Object object = monitor;
        synchronized (object) {
            String line = input + "\n";
            for (byte b : line.getBytes()) {
                SystemInUtil.singleton.data.add(b);
            }
            SystemInUtil.singleton.endReached = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        this.beingUsed = true;
        Object object = monitor;
        synchronized (object) {
            int current = this.counter.get();
            if (Thread.currentThread().isInterrupted()) {
                return -1;
            }
            if (current >= this.data.size()) {
                if (!this.endReached) {
                    this.endReached = true;
                    return -1;
                }
                throw new IOException("Simulated exception in System.in");
            }
            int i = this.counter.getAndIncrement();
            return this.data.get(i).byteValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = monitor;
        synchronized (object) {
            return this.data.size() - this.counter.get();
        }
    }

    public boolean hasBeenUsed() {
        return this.beingUsed;
    }
}

