/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.util.ArrayDeque;
import java.util.Queue;
import org.evosuite.Properties;
import org.evosuite.seeding.FrequencyBasedPool;
import org.evosuite.utils.RandomAccessQueue;

public class FrequencyBasedRandomAccessQueue<T>
implements RandomAccessQueue<T> {
    private final FrequencyBasedPool<T> values = new FrequencyBasedPool();
    private final Queue<T> queue = new ArrayDeque<T>();

    @Override
    public void restrictedAdd(T value) {
        this.values.addConstant(value);
        this.queue.add(value);
        this.reduceSize();
    }

    private void reduceSize() {
        if (this.queue.size() > Properties.DYNAMIC_POOL_SIZE) {
            T value = this.queue.poll();
            this.values.removeConstant(value);
        }
    }

    @Override
    public T getRandomValue() {
        return this.values.getRandomConstant();
    }

    public String toString() {
        String res = "[ ";
        for (Object element : this.queue) {
            res = res + element + " ";
        }
        res = res + "]";
        return res;
    }
}

