/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public final class TestCaseRecycler<T extends Chromosome<T>>
implements SearchListener<T> {
    private static final long serialVersionUID = -2372656982678139994L;
    private static TestCaseRecycler<?> instance;
    private final Set<TestCase> testPool = new LinkedHashSet<TestCase>();

    public static <T extends Chromosome<T>> TestCaseRecycler<T> getInstance() {
        if (instance == null) {
            instance = new TestCaseRecycler<T>();
        }
        return instance;
    }

    private TestCaseRecycler() {
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
        T individual = algorithm.getBestIndividual();
        if (individual instanceof TestChromosome) {
            TestChromosome testChromosome = (TestChromosome)individual;
            this.testPool.add(testChromosome.getTestCase());
        } else if (individual instanceof TestSuiteChromosome) {
            TestSuiteChromosome testSuiteChromosome = (TestSuiteChromosome)individual;
            this.testPool.addAll(testSuiteChromosome.getTests());
        }
    }

    @Override
    public void fitnessEvaluation(T individual) {
    }

    @Override
    public void modification(T individual) {
    }
}

