/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ResourceList;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.junit.CoverageAnalysis;
import org.evosuite.rmi.ClientServices;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.InheritanceTreeGenerator;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.setup.callgraph.CallGraph;
import org.evosuite.setup.callgraph.CallGraphGenerator;
import org.evosuite.shaded.org.objectweb.asm.ClassReader;
import org.evosuite.shaded.org.objectweb.asm.tree.ClassNode;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.utils.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(DependencyAnalysis.class);
    private static Map<String, ClassNode> classCache = new LinkedHashMap<String, ClassNode>();
    private static Map<String, CallGraph> callGraphs = new LinkedHashMap<String, CallGraph>();
    private static InheritanceTree inheritanceTree = null;
    private static Set<String> targetClasses = null;

    public static InheritanceTree getInheritanceTree() {
        return inheritanceTree;
    }

    public static void initInheritanceTree(List<String> classPath) {
        if (inheritanceTree == null) {
            logger.debug("Calculate inheritance hierarchy");
            inheritanceTree = InheritanceTreeGenerator.createFromClassPath(classPath);
        }
        TestClusterGenerator clusterGenerator = new TestClusterGenerator(inheritanceTree);
        TestGenerationContext.getInstance().setTestClusterGenerator(clusterGenerator);
        InheritanceTreeGenerator.gatherStatistics(inheritanceTree);
    }

    public static void initCallGraph(String className) {
        logger.debug("Calculate call tree");
        CallGraph callGraph = CallGraphGenerator.analyze(className);
        callGraphs.put(className, callGraph);
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.IBRANCH) || Properties.INSTRUMENT_CONTEXT) {
            for (String classn : inheritanceTree.getAllClasses()) {
                if (!DependencyAnalysis.isTargetProject(classn)) continue;
                CallGraphGenerator.analyzeOtherClasses(callGraph, classn);
            }
        }
        logger.debug("Update call tree with calls to overridden methods");
        CallGraphGenerator.update(callGraph, inheritanceTree);
    }

    private static void analyze(String className) throws RuntimeException, ClassNotFoundException {
        if (!inheritanceTree.hasClass(Properties.TARGET_CLASS)) {
            throw new ClassNotFoundException("Target class not found in inheritance tree");
        }
        CallGraph callGraph = callGraphs.get(className);
        DependencyAnalysis.loadCallTreeClasses(callGraph);
        logger.debug("Create test cluster");
        TestGenerationContext.getInstance().getTestClusterGenerator().generateCluster(callGraph);
        DependencyAnalysis.gatherStatistics();
    }

    public static void analyzeClass(String className, List<String> classPath) throws RuntimeException, ClassNotFoundException {
        DependencyAnalysis.initInheritanceTree(classPath);
        DependencyAnalysis.initCallGraph(className);
        DependencyAnalysis.analyze(className);
    }

    public static Set<String> analyzeTarget(String target, List<String> classPath) throws RuntimeException, ClassNotFoundException {
        DependencyAnalysis.initInheritanceTree(classPath);
        targetClasses = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(target, false);
        Iterator<String> iterator = targetClasses.iterator();
        while (iterator.hasNext()) {
            String className;
            Properties.TARGET_CLASS = className = iterator.next();
            DependencyAnalysis.initCallGraph(className);
            DependencyAnalysis.analyze(className);
        }
        return targetClasses;
    }

    private static void loadCallTreeClasses(CallGraph callGraph) {
        for (String className : callGraph.getClasses()) {
            if (!className.startsWith(Properties.TARGET_CLASS + "$")) continue;
            try {
                Class.forName(className, true, TestGenerationContext.getInstance().getClassLoaderForSUT());
            }
            catch (ClassNotFoundException e) {
                logger.debug("Error loading " + className + ": " + e);
            }
        }
    }

    public static CallGraph getCallGraph(String className) {
        return callGraphs.get(className);
    }

    public static CallGraph getCallGraph() {
        return callGraphs.get(Properties.TARGET_CLASS);
    }

    public static boolean isTargetClassName(String className) {
        if (!Properties.TARGET_CLASS_PREFIX.isEmpty() && className.startsWith(Properties.TARGET_CLASS_PREFIX)) {
            try {
                Class<?> clazz = Class.forName(className);
                return !CoverageAnalysis.isTest(clazz);
            }
            catch (ClassNotFoundException e) {
                logger.info("Could not find class " + className);
            }
        }
        if (className.equals(Properties.TARGET_CLASS) || className.startsWith(Properties.TARGET_CLASS + "$")) {
            return true;
        }
        return targetClasses != null && targetClasses.contains(className);
    }

    public static boolean isTargetProject(String className) {
        return (className.startsWith(Properties.PROJECT_PREFIX) || !Properties.TARGET_CLASS_PREFIX.isEmpty() && className.startsWith(Properties.TARGET_CLASS_PREFIX)) && !className.startsWith("java.") && !className.startsWith("sun.") && !className.startsWith(PackageInfo.getEvoSuitePackage()) && !className.startsWith("org.exsyst") && !className.startsWith("de.unisb.cs.st.evosuite") && !className.startsWith("de.unisb.cs.st.specmate") && !className.startsWith("javax.") && !className.startsWith("org.xml") && !className.startsWith("org.w3c") && !className.startsWith("apple.") && !className.startsWith("com.apple.") && !className.startsWith("org.omg.") && !className.startsWith("sunw.") && !className.startsWith("org.jcp.") && !className.startsWith("org.ietf.") && !className.startsWith("daikon.") && !className.startsWith("jdk.");
    }

    public static boolean shouldAnalyze(String className) {
        CallGraph callGraph;
        if (DependencyAnalysis.isTargetClassName(className)) {
            return true;
        }
        if (inheritanceTree == null) {
            return false;
        }
        if (Properties.INSTRUMENT_PARENT && inheritanceTree.getSuperclasses(Properties.TARGET_CLASS).contains(className)) {
            return true;
        }
        return (Properties.INSTRUMENT_CONTEXT || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.IBRANCH)) && (callGraph = callGraphs.get(Properties.TARGET_CLASS)) != null && callGraph.isCalledClass(className);
    }

    public static boolean shouldInstrument(String className, String methodName) {
        CallGraph callGraph;
        if (DependencyAnalysis.isTargetClassName(className)) {
            return true;
        }
        if (Properties.INSTRUMENT_PARENT && inheritanceTree.getSuperclasses(Properties.TARGET_CLASS).contains(className)) {
            return true;
        }
        return Properties.INSTRUMENT_CONTEXT && (callGraph = callGraphs.get(Properties.TARGET_CLASS)) != null && callGraph.isCalledMethod(className, methodName) && (Properties.INSTRUMENT_LIBRARIES || DependencyAnalysis.isTargetProject(className));
    }

    public static ClassNode getClassNode(String className) {
        if (!classCache.containsKey(className)) {
            try {
                classCache.put(className, DependencyAnalysis.loadClassNode(className));
            }
            catch (IOException e) {
                classCache.put(className, null);
            }
        }
        return classCache.get(className);
    }

    public static Collection<ClassNode> getAllClassNodes() {
        return classCache.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassNode loadClassNode(String className) throws IOException {
        InputStream classStream = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getClassAsStream(className);
        if (classStream == null) {
            logger.info("Could not find class file: " + className);
            return null;
        }
        ClassNode cn = new ClassNode();
        try {
            ClassReader reader = new ClassReader(classStream);
            reader.accept(cn, 4);
        }
        finally {
            classStream.close();
        }
        return cn;
    }

    private static void gatherStatistics() {
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Predicates, BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranchCounter());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Instrumented_Predicates, BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getNumArtificialBranches());
        int numBranches = BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranchCounter() * 2;
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Branches, numBranches);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Branches_Real, (BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranchCounter() - BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getNumArtificialBranches()) * 2);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Branches_Instrumented, BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getNumArtificialBranches() * 2);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Branchless_Methods, BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranchlessMethods().size());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Methods, CFGMethodAdapter.getNumMethods(TestGenerationContext.getInstance().getClassLoaderForSUT()));
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Lines, LinePool.getNumLines());
        block4: for (Properties.Criterion pc : Properties.CRITERION) {
            switch (pc) {
                case DEFUSE: 
                case ALLDEFS: {
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Definitions, DefUsePool.getDefCounter());
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Uses, DefUsePool.getUseCounter());
                    continue block4;
                }
                case WEAKMUTATION: 
                case STRONGMUTATION: 
                case MUTATION: {
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Mutants, MutationPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getMutantCounter());
                    continue block4;
                }
            }
        }
    }
}

