/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.runtime.Random;
import org.evosuite.runtime.System;
import org.evosuite.runtime.annotation.EvoSuiteAssertionOnly;
import org.evosuite.runtime.annotation.EvoSuiteClassExclude;
import org.evosuite.runtime.annotation.EvoSuiteExclude;
import org.evosuite.runtime.annotation.EvoSuiteInclude;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.testdata.EvoSuiteRemoteAddress;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.evosuite.runtime.util.JOptionPaneInputs;
import org.evosuite.runtime.util.SystemInUtil;
import org.evosuite.runtime.vfs.VirtualFileSystem;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.runtime.vnet.VirtualNetwork;
import org.evosuite.setup.TestCluster;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentTestClusterAugmenter {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentTestClusterAugmenter.class);
    private volatile boolean hasAddedRandom;
    private volatile boolean hasAddedSystem;
    private volatile boolean hasAddedFiles;
    private volatile boolean hasAddedSystemIn;
    private volatile boolean hasAddedRemoteURLs;
    private volatile boolean hasAddedUdpSupport;
    private volatile boolean hasAddedTcpListeningSupport;
    private volatile boolean hasAddedTcpRemoteSupport;
    private final TestCluster cluster;
    private TestClusterGenerator testClusterGenerator;
    private final Set<String> handledClasses;
    private boolean hasAddedJOptionPaneInputsForStrings = false;
    private boolean hasAddedJOptionPaneYesNoCancelSelection = false;
    private boolean hasAddedJOptionPaneYesNoSelection = false;
    private boolean hasAddedJOptionPaneOkCancelSelection = false;
    private boolean hasAddedJOptionPaneOptionSelection = false;

    public EnvironmentTestClusterAugmenter(TestCluster cluster) {
        this.cluster = cluster;
        this.testClusterGenerator = TestGenerationContext.getInstance().getTestClusterGenerator();
        this.handledClasses = new LinkedHashSet<String>();
    }

    public void handleRuntimeAccesses(TestCase test) {
        if (this.testClusterGenerator == null) {
            this.testClusterGenerator = TestGenerationContext.getInstance().getTestClusterGenerator();
            if (this.testClusterGenerator == null) {
                return;
            }
        }
        test.getAccessedEnvironment().clear();
        if (Properties.REPLACE_CALLS) {
            this.handleReplaceCalls();
        }
        if (Properties.VIRTUAL_FS) {
            this.handleVirtualFS(test);
        }
        if (Properties.REPLACE_SYSTEM_IN) {
            this.handleSystemIn();
        }
        if (Properties.REPLACE_GUI) {
            this.handleGUI();
        }
        if (Properties.VIRTUAL_NET) {
            this.handleNetwork(test);
        }
    }

    private void handleGUI() {
        GenericMethod genericMethod;
        GenericClass genericClass;
        Method method_to_call;
        Class<JOptionPaneInputs> clazz;
        if (!this.hasAddedJOptionPaneInputsForStrings && JOptionPaneInputs.getInstance().hasDialog(JOptionPaneInputs.GUIAction.STRING_INPUT)) {
            this.hasAddedJOptionPaneInputsForStrings = true;
            try {
                clazz = JOptionPaneInputs.class;
                String ENQUEUE_INPUT_STRING = "enqueueInputString";
                method_to_call = clazz.getMethod("enqueueInputString", String.class);
                genericClass = new GenericClass(clazz);
                genericMethod = new GenericMethod(method_to_call, genericClass);
                TestCluster.getInstance().addEnvironmentTestCall(genericMethod);
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedJOptionPaneYesNoCancelSelection && JOptionPaneInputs.getInstance().hasDialog(JOptionPaneInputs.GUIAction.YES_NO_CANCEL_SELECTION)) {
            this.hasAddedJOptionPaneYesNoCancelSelection = true;
            try {
                clazz = JOptionPaneInputs.class;
                String ENQUEUE_YES_NO_CANCEL_SELECTION = "enqueueYesNoCancelSelection";
                method_to_call = clazz.getMethod("enqueueYesNoCancelSelection", Integer.TYPE);
                genericClass = new GenericClass(clazz);
                genericMethod = new GenericMethod(method_to_call, genericClass);
                TestCluster.getInstance().addEnvironmentTestCall(genericMethod);
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedJOptionPaneYesNoSelection && JOptionPaneInputs.getInstance().hasDialog(JOptionPaneInputs.GUIAction.YES_NO_SELECTION)) {
            this.hasAddedJOptionPaneYesNoSelection = true;
            try {
                clazz = JOptionPaneInputs.class;
                String ENQUEUE_YES_NO_SELECTION = "enqueueYesNoSelection";
                method_to_call = clazz.getMethod("enqueueYesNoSelection", Integer.TYPE);
                genericClass = new GenericClass(clazz);
                genericMethod = new GenericMethod(method_to_call, genericClass);
                TestCluster.getInstance().addEnvironmentTestCall(genericMethod);
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedJOptionPaneOkCancelSelection && JOptionPaneInputs.getInstance().hasDialog(JOptionPaneInputs.GUIAction.OK_CANCEL_SELECTION)) {
            this.hasAddedJOptionPaneOkCancelSelection = true;
            try {
                clazz = JOptionPaneInputs.class;
                String ENQUEUE_OK_CANCEL_SELECTION = "enqueueOkCancelSelection";
                method_to_call = clazz.getMethod("enqueueOkCancelSelection", Integer.TYPE);
                genericClass = new GenericClass(clazz);
                genericMethod = new GenericMethod(method_to_call, genericClass);
                TestCluster.getInstance().addEnvironmentTestCall(genericMethod);
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedJOptionPaneOptionSelection && JOptionPaneInputs.getInstance().hasDialog(JOptionPaneInputs.GUIAction.OPTION_SELECTION)) {
            this.hasAddedJOptionPaneOptionSelection = true;
            try {
                clazz = JOptionPaneInputs.class;
                String ENQUEUE_OPTION_SELECTION = "enqueueOptionSelection";
                method_to_call = clazz.getMethod("enqueueOptionSelection", Integer.TYPE);
                genericClass = new GenericClass(clazz);
                genericMethod = new GenericMethod(method_to_call, genericClass);
                TestCluster.getInstance().addEnvironmentTestCall(genericMethod);
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
    }

    private boolean addEnvironmentClassToCluster(Class<?> klass) {
        if (this.handledClasses.contains(klass.getCanonicalName()) || !TestClusterUtils.isEvoSuiteClass(klass)) {
            return false;
        }
        this.handledClasses.add(klass.getCanonicalName());
        boolean excludeClass = klass.getAnnotation(EvoSuiteClassExclude.class) != null;
        for (Constructor<?> constructor : klass.getConstructors()) {
            if (this.shouldSkip(excludeClass, constructor)) continue;
            GenericConstructor gc = new GenericConstructor(constructor, klass);
            TestCluster.getInstance().addEnvironmentTestCall(gc);
            GenericClass genclass = new GenericClass(klass);
            TestCluster.getInstance().invalidateGeneratorCache(genclass);
            TestCluster.getInstance().addGenerator(genclass, gc);
            this.testClusterGenerator.addNewDependencies(Arrays.asList(constructor.getParameterTypes()));
        }
        for (Executable executable : klass.getMethods()) {
            if (this.shouldSkip(excludeClass, executable)) continue;
            GenericMethod gm = new GenericMethod((Method)executable, klass);
            TestCluster.getInstance().addEnvironmentTestCall(gm);
            this.testClusterGenerator.addNewDependencies(Arrays.asList(((Method)executable).getParameterTypes()));
            Class<?> returnType = ((Method)executable).getReturnType();
            if (returnType.equals(Void.TYPE)) continue;
            GenericClass genclass = new GenericClass(returnType);
            TestCluster.getInstance().invalidateGeneratorCache(genclass);
            TestCluster.getInstance().addGenerator(genclass, gm);
            this.addEnvironmentDependency(returnType);
        }
        return true;
    }

    private void addEnvironmentDependency(Class<?> klass) {
        if (this.handledClasses.contains(klass.getCanonicalName()) || !TestClusterUtils.isEvoSuiteClass(klass)) {
            return;
        }
        this.handledClasses.add(klass.getCanonicalName());
        boolean excludeClass = klass.getAnnotation(EvoSuiteClassExclude.class) != null;
        for (Method m : klass.getMethods()) {
            if (this.shouldSkip(excludeClass, m)) continue;
            GenericMethod gm = new GenericMethod(m, klass);
            GenericClass gc = new GenericClass(klass);
            TestCluster.getInstance().addModifier(gc, gm);
            this.testClusterGenerator.addNewDependencies(Arrays.asList(m.getParameterTypes()));
            Class<?> returnType = m.getReturnType();
            if (returnType.equals(Void.TYPE)) continue;
            GenericClass genclass = new GenericClass(returnType);
            TestCluster.getInstance().invalidateGeneratorCache(genclass);
            TestCluster.getInstance().addGenerator(genclass, gm);
            this.addEnvironmentDependency(returnType);
        }
    }

    private boolean isObjectMethod(AccessibleObject ao) {
        String name;
        if (!(ao instanceof Method)) {
            return false;
        }
        Method m = (Method)ao;
        switch (name = m.getName()) {
            case "clone": 
            case "equals": 
            case "finalize": 
            case "getClass": 
            case "hashCode": 
            case "notify": 
            case "notifyAll": 
            case "toString": 
            case "wait": {
                return true;
            }
        }
        return false;
    }

    private boolean shouldSkip(boolean excludeClass, AccessibleObject c) {
        if (this.isObjectMethod(c)) {
            return true;
        }
        if (excludeClass) {
            boolean include;
            boolean bl = include = c.getAnnotation(EvoSuiteInclude.class) != null;
            if (!include) {
                return true;
            }
        } else {
            boolean exclude;
            boolean bl = exclude = c.getAnnotation(EvoSuiteExclude.class) != null || c.getAnnotation(EvoSuiteAssertionOnly.class) != null;
            if (exclude) {
                return true;
            }
        }
        return false;
    }

    private void handleNetwork(TestCase test) {
        test.getAccessedEnvironment().addLocalListeningPorts(VirtualNetwork.getInstance().getViewOfLocalListeningPorts());
        test.getAccessedEnvironment().addRemoteURLs(VirtualNetwork.getInstance().getViewOfRemoteAccessedFiles());
        test.getAccessedEnvironment().addRemoteContactedPorts(VirtualNetwork.getInstance().getViewOfRemoteContactedPorts());
        if (!this.hasAddedRemoteURLs && test.getAccessedEnvironment().getViewOfRemoteURLs().size() > 0) {
            this.hasAddedRemoteURLs = true;
            try {
                TestCluster.getInstance().addEnvironmentTestCall(new GenericMethod(NetworkHandling.class.getMethod("createRemoteTextFile", EvoSuiteURL.class, String.class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedRemoteURLs: " + e.getMessage(), e);
            }
        }
        boolean openedTCP = false;
        boolean openedUDP = false;
        for (EndPointInfo info : test.getAccessedEnvironment().getViewOfLocalListeningPorts()) {
            if (info.getType().equals((Object)VirtualNetwork.ConnectionType.TCP)) {
                openedTCP = true;
            } else if (info.getType().equals((Object)VirtualNetwork.ConnectionType.UDP)) {
                openedUDP = true;
            }
            if (!openedTCP || !openedUDP) continue;
            break;
        }
        if (!this.hasAddedUdpSupport && openedUDP) {
            this.hasAddedUdpSupport = true;
            try {
                TestCluster.getInstance().addEnvironmentTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendUdpPacket", EvoSuiteLocalAddress.class, EvoSuiteRemoteAddress.class, byte[].class), new GenericClass(NetworkHandling.class)));
                TestCluster.getInstance().addEnvironmentTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendUdpPacket", EvoSuiteLocalAddress.class, byte[].class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedUdpSupport: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedTcpListeningSupport && openedTCP) {
            this.hasAddedTcpListeningSupport = true;
            try {
                TestCluster.getInstance().addEnvironmentTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendDataOnTcp", EvoSuiteLocalAddress.class, byte[].class), new GenericClass(NetworkHandling.class)));
                TestCluster.getInstance().addEnvironmentTestCall(new GenericMethod(NetworkHandling.class.getMethod("sendMessageOnTcp", EvoSuiteLocalAddress.class, String.class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedTcpListeningSupport: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedTcpRemoteSupport && test.getAccessedEnvironment().getViewOfRemoteContactedPorts().size() > 0) {
            this.hasAddedTcpRemoteSupport = true;
            try {
                TestCluster.getInstance().addEnvironmentTestCall(new GenericMethod(NetworkHandling.class.getMethod("openRemoteTcpServer", EvoSuiteRemoteAddress.class), new GenericClass(NetworkHandling.class)));
            }
            catch (Exception e) {
                logger.error("Error while handling hasAddedTcpRemoteSupport: " + e.getMessage(), e);
            }
        }
    }

    private void handleSystemIn() {
        if (!this.hasAddedSystemIn && SystemInUtil.getInstance().hasBeenUsed()) {
            this.hasAddedSystemIn = true;
            try {
                TestCluster.getInstance().addEnvironmentTestCall(new GenericMethod(SystemInUtil.class.getMethod("addInputLine", String.class), new GenericClass(SystemInUtil.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
    }

    private void handleVirtualFS(TestCase test) {
        test.getAccessedEnvironment().addLocalFiles(VirtualFileSystem.getInstance().getAccessedFiles());
        if (!this.hasAddedFiles && VirtualFileSystem.getInstance().getAccessedFiles().size() > 0) {
            logger.info("Adding EvoSuiteFile calls to cluster");
            this.hasAddedFiles = true;
            this.addEnvironmentClassToCluster(FileSystemHandling.class);
        }
    }

    private void handleReplaceCalls() {
        if (!this.hasAddedRandom && Random.wasAccessed()) {
            this.hasAddedRandom = true;
            try {
                this.cluster.addTestCall(new GenericMethod(Random.class.getMethod("setNextRandom", Integer.TYPE), new GenericClass(Random.class)));
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.error("Error while handling Random: " + e.getMessage(), e);
            }
        }
        if (!this.hasAddedSystem && System.wasTimeAccessed()) {
            this.hasAddedSystem = true;
            try {
                this.cluster.addTestCall(new GenericMethod(System.class.getMethod("setCurrentTimeMillis", Long.TYPE), new GenericClass(System.class)));
            }
            catch (SecurityException e) {
                logger.error("Error while handling System: " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error while handling System: " + e.getMessage(), e);
            }
        }
    }
}

