/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.util.Set;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.shaded.org.mockito.Spy;
import org.evosuite.shaded.org.mockito.exceptions.base.MockitoException;
import org.evosuite.shaded.org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.evosuite.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.evosuite.shaded.org.mockito.internal.util.MockUtil;
import org.evosuite.shaded.org.mockito.internal.util.reflection.FieldReader;
import org.evosuite.shaded.org.mockito.plugins.MemberAccessor;

public class SpyOnInjectedFieldsHandler
extends MockInjectionStrategy {
    private final MemberAccessor accessor = Plugins.getMemberAccessor();

    @Override
    protected boolean processInjection(Field field, Object fieldOwner, Set<Object> mockCandidates) {
        FieldReader fieldReader = new FieldReader(fieldOwner, field);
        if (!fieldReader.isNull() && field.isAnnotationPresent(Spy.class)) {
            try {
                Object instance = fieldReader.read();
                if (MockUtil.isMock(instance)) {
                    Mockito.reset(instance);
                } else {
                    Object mock = Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName()));
                    this.accessor.set(field, fieldOwner, mock);
                }
            }
            catch (Exception e) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), e);
            }
        }
        return false;
    }
}

