/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.debugging;

import java.io.Serializable;
import org.evosuite.shaded.org.mockito.internal.exceptions.stacktrace.StackTraceFilter;
import org.evosuite.shaded.org.mockito.invocation.Location;

public class LocationImpl
implements Location,
Serializable {
    private static final long serialVersionUID = -9054861157390980624L;
    private static final StackTraceFilter stackTraceFilter = new StackTraceFilter();
    private String stackTraceLine;
    private String sourceFile;

    public LocationImpl() {
        this(new Throwable(), false);
    }

    public LocationImpl(Throwable stackTraceHolder, boolean isInline) {
        this(stackTraceFilter, stackTraceHolder, isInline);
    }

    public LocationImpl(StackTraceFilter stackTraceFilter) {
        this(stackTraceFilter, new Throwable(), false);
    }

    private LocationImpl(StackTraceFilter stackTraceFilter, Throwable stackTraceHolder, boolean isInline) {
        this.computeStackTraceInformation(stackTraceFilter, stackTraceHolder, isInline);
    }

    @Override
    public String toString() {
        return this.stackTraceLine;
    }

    private void computeStackTraceInformation(StackTraceFilter stackTraceFilter, Throwable stackTraceHolder, boolean isInline) {
        StackTraceElement filtered = stackTraceFilter.filterFirst(stackTraceHolder, isInline);
        if (filtered == null) {
            this.stackTraceLine = "-> at <<unknown line>>";
            this.sourceFile = "<unknown source file>";
        } else {
            this.stackTraceLine = "-> at " + filtered.toString();
            this.sourceFile = filtered.getFileName();
        }
    }

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }
}

