/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.evosuite.shaded.org.mockito.internal.configuration.plugins.Plugins;
import org.evosuite.shaded.org.mockito.plugins.MemberAccessor;

public class LenientCopyTool {
    MemberAccessor accessor = Plugins.getMemberAccessor();

    public <T> void copyToMock(T from, T mock) {
        this.copy(from, mock, from.getClass());
    }

    public <T> void copyToRealObject(T from, T to) {
        this.copy(from, to, from.getClass());
    }

    private <T> void copy(T from, T to, Class<?> fromClazz) {
        while (fromClazz != Object.class) {
            this.copyValues(from, to, fromClazz);
            fromClazz = fromClazz.getSuperclass();
        }
    }

    private <T> void copyValues(T from, T mock, Class<?> classFrom) {
        Field[] fields;
        for (Field field : fields = classFrom.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object value = this.accessor.get(field, from);
                this.accessor.set(field, mock, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

