/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.statistics.OutputVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RuntimeVariable {
    Predicates,
    Instrumented_Predicates,
    Classpath_Classes,
    Analyzed_Classes,
    Generators,
    Modifiers,
    Total_Branches,
    Covered_Branches,
    Gradient_Branches,
    Gradient_Branches_Covered,
    Lines,
    Covered_Lines,
    Total_Methods,
    Covered_Methods,
    Branchless_Methods,
    Covered_Branchless_Methods,
    Total_Goals,
    Covered_Goals,
    Mutants,
    Statements_Executed,
    Tests_Executed,
    Fitness_Evaluations,
    Generations,
    Coverage,
    CoverageBitString,
    Fitness,
    CoverageTimeline,
    FitnessTimeline,
    DiversityTimeline,
    Size_T0,
    SizeTimeline,
    LengthTimeline,
    StatementCoverage,
    StatementCoverageBitString,
    RhoScore,
    RhoScore_T0,
    RhoScoreTimeline,
    AmbiguityScore,
    AmbiguityScore_T0,
    AmbiguityScoreTimeline,
    BranchCoverage,
    Total_Branches_Real,
    Total_Branches_Instrumented,
    Covered_Branches_Real,
    Covered_Branches_Instrumented,
    TryCatchCoverage,
    BranchCoverageTimeline,
    BranchCoverageBitString,
    OnlyBranchCoverage,
    OnlyBranchFitnessTimeline,
    OnlyBranchCoverageTimeline,
    OnlyBranchCoverageBitString,
    CBranchCoverage,
    CBranchFitnessTimeline,
    CBranchCoverageTimeline,
    CBranchCoverageBitString,
    IBranchCoverage,
    IBranchInitialGoals,
    IBranchInitialGoalsInTargetClass,
    IBranchGoalsTimeline,
    IBranchCoverageBitString,
    MethodTraceCoverage,
    MethodTraceFitnessTimeline,
    MethodTraceCoverageTimeline,
    MethodTraceCoverageBitString,
    MethodCoverage,
    MethodFitnessTimeline,
    MethodCoverageTimeline,
    MethodCoverageBitString,
    MethodNoExceptionCoverage,
    MethodNoExceptionFitnessTimeline,
    MethodNoExceptionCoverageTimeline,
    MethodNoExceptionCoverageBitString,
    LineCoverage,
    LineFitnessTimeline,
    LineCoverageTimeline,
    LineCoverageBitString,
    OutputCoverage,
    OutputFitnessTimeline,
    OutputCoverageTimeline,
    OutputCoverageBitString,
    InputCoverage,
    InputFitnessTimeline,
    InputCoverageTimeline,
    InputCoverageBitString,
    ExceptionCoverage,
    ExceptionFitnessTimeline,
    ExceptionCoverageTimeline,
    ExceptionCoverageBitString,
    WeakMutationScore,
    WeakMutationCoverageTimeline,
    WeakMutationCoverageBitString,
    OnlyMutationScore,
    OnlyMutationFitnessTimeline,
    OnlyMutationCoverageTimeline,
    OnlyMutationCoverageBitString,
    MutationScore,
    MutationCoverageBitString,
    Total_Time,
    Size,
    Length,
    Result_Size,
    Result_Length,
    Minimized_Size,
    Minimized_Length,
    Random_Seed,
    CarvedTests,
    CarvedCoverage,
    HadUnstableTests,
    NumUnstableTests,
    Threads,
    Explicit_MethodExceptions,
    Explicit_TypeExceptions,
    Implicit_MethodExceptions,
    Implicit_TypeExceptions,
    TotalExceptionsTimeline,
    DensityTimeline,
    FeaturePartitionCount,
    FeatureCount,
    FeaturesFound,
    AllPermission,
    SecurityPermission,
    UnresolvedPermission,
    AWTPermission,
    FilePermission,
    SerializablePermission,
    ReflectPermission,
    RuntimePermission,
    NetPermission,
    SocketPermission,
    SQLPermission,
    PropertyPermission,
    LoggingPermission,
    SSLPermission,
    AuthPermission,
    AudioPermission,
    OtherPermission,
    Time_Assertion,
    Time_Coverage,
    Time_StateDistance,
    Time_Diversity,
    Cmp_IntZero,
    Cmp_IntInt,
    Cmp_RefNull,
    Cmp_RefRef,
    Reached_IntZero,
    Reached_IntInt,
    Reached_RefNull,
    Reached_RefRef,
    Covered_IntZero,
    Covered_IntInt,
    Covered_RefNull,
    Covered_RefRef,
    BC_lcmp,
    BC_fcmpl,
    BC_fcmpg,
    BC_dcmpl,
    BC_dcmpg,
    Reached_lcmp,
    Reached_fcmpl,
    Reached_fcmpg,
    Reached_dcmpl,
    Reached_dcmpg,
    Covered_lcmp,
    Covered_fcmpl,
    Covered_fcmpg,
    Covered_dcmpl,
    Covered_dcmpg,
    RSM_OverMinimized,
    NumberOfInputPoolObjects,
    Error_Predicates,
    Error_Branches_Covered,
    Error_Branchless_Methods,
    Error_Branchless_Methods_Covered,
    AssertionContract,
    EqualsContract,
    EqualsHashcodeContract,
    EqualsNullContract,
    EqualsSymmetricContract,
    HashCodeReturnsNormallyContract,
    JCrasherExceptionContract,
    NullPointerExceptionContract,
    ToStringReturnsNormallyContract,
    UndeclaredExceptionContract,
    Contract_Violations,
    Unique_Violations,
    Data_File,
    AllDefCoverage,
    AllDefCoverageBitString,
    DefUseCoverage,
    DefUseCoverageBitString,
    Definitions,
    Uses,
    DefUsePairs,
    IntraMethodPairs,
    InterMethodPairs,
    IntraClassPairs,
    ParameterPairs,
    LCSAJs,
    AliasingIntraMethodPairs,
    AliasingInterMethodPairs,
    AliasingIntraClassPairs,
    AliasingParameterPairs,
    CoveredIntraMethodPairs,
    CoveredInterMethodPairs,
    CoveredIntraClassPairs,
    CoveredParameterPairs,
    CoveredAliasIntraMethodPairs,
    CoveredAliasInterMethodPairs,
    CoveredAliasIntraClassPairs,
    CoveredAliasParameterPairs,
    IntegerOnlyConstraints,
    RealOnlyConstraints,
    StringOnlyConstraints,
    IntegerAndRealConstraints,
    IntegerAndStringConstraints,
    RealAndStringConstraints,
    IntegerRealAndStringConstraints,
    TotalNumberOfConstraints,
    NumberOfSATQueries,
    NumberOfUNSATQueries,
    NumberOfTimeoutQueries,
    NumberOfUsefulNewTests,
    NumberOfUnusefulNewTests,
    Time2MaxCoverage;

    private static final Logger logger;

    public static boolean validateRuntimeVariables(Map<String, OutputVariable<?>> map) {
        if (!Properties.VALIDATE_RUNTIME_VARIABLES) {
            logger.warn("Not validating runtime variables");
            return true;
        }
        boolean valid = true;
        try {
            double diff;
            Integer totalBranches = RuntimeVariable.getIntegerValue(map, Total_Branches);
            Integer coveredBranches = RuntimeVariable.getIntegerValue(map, Covered_Branches);
            if (coveredBranches != null && totalBranches != null && coveredBranches > totalBranches) {
                logger.error("Obtained invalid branch count: covered " + coveredBranches + " out of " + totalBranches);
                valid = false;
            }
            Integer totalGoals = RuntimeVariable.getIntegerValue(map, Total_Goals);
            Integer coveredGoals = RuntimeVariable.getIntegerValue(map, Covered_Goals);
            if (coveredGoals != null && totalGoals != null && coveredGoals > totalGoals) {
                logger.error("Obtained invalid goal count: covered " + coveredGoals + " out of " + totalGoals);
                valid = false;
            }
            Integer totalMethods = RuntimeVariable.getIntegerValue(map, Total_Methods);
            Integer coveredMethods = RuntimeVariable.getIntegerValue(map, Covered_Methods);
            if (coveredMethods != null && totalMethods != null && coveredMethods > totalMethods) {
                logger.error("Obtained invalid method count: covered " + coveredMethods + " out of " + totalMethods);
                valid = false;
            }
            String[] criteria = null;
            if (map.containsKey("criterion")) {
                criteria = map.get("criterion").toString().split(":");
            }
            Double coverage = RuntimeVariable.getDoubleValue(map, Coverage);
            Double branchCoverage = RuntimeVariable.getDoubleValue(map, BranchCoverage);
            if (criteria != null && criteria.length == 1 && criteria[0].equalsIgnoreCase(Properties.Criterion.BRANCH.toString()) && coverage != null && branchCoverage != null && (diff = Math.abs(coverage - branchCoverage)) > 0.001) {
                logger.error("Targeting branch coverage, but Coverage is different from BranchCoverage: " + coverage + " != " + branchCoverage);
                valid = false;
            }
        }
        catch (Exception e) {
            logger.error("Exception while validating runtime variables: " + e.getMessage(), e);
            valid = false;
        }
        return valid;
    }

    private static Integer getIntegerValue(Map<String, OutputVariable<?>> map, RuntimeVariable variable) {
        OutputVariable<?> out = map.get(variable.toString());
        if (out != null) {
            return (Integer)out.getValue();
        }
        return null;
    }

    private static Double getDoubleValue(Map<String, OutputVariable<?>> map, RuntimeVariable variable) {
        OutputVariable<?> out = map.get(variable.toString());
        if (out != null) {
            return (Double)out.getValue();
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(RuntimeVariable.class);
    }
}

