/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.evosuite.Properties;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageSuiteFitness;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.branch.OnlyBranchCoverageSuiteFitness;
import org.evosuite.coverage.cbranch.CBranchSuiteFitness;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.coverage.io.input.InputCoverageSuiteFitness;
import org.evosuite.coverage.io.output.OutputCoverageSuiteFitness;
import org.evosuite.coverage.line.LineCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodTraceCoverageSuiteFitness;
import org.evosuite.coverage.mutation.OnlyMutationSuiteFitness;
import org.evosuite.coverage.mutation.WeakMutationSuiteFitness;
import org.evosuite.coverage.rho.RhoCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.rmi.MasterServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.statistics.ChromosomeOutputVariableFactory;
import org.evosuite.statistics.DirectSequenceOutputVariableFactory;
import org.evosuite.statistics.OutputVariable;
import org.evosuite.statistics.PropertyOutputVariableFactory;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.SequenceOutputVariableFactory;
import org.evosuite.statistics.backend.CSVStatisticsBackend;
import org.evosuite.statistics.backend.ConsoleStatisticsBackend;
import org.evosuite.statistics.backend.DebugStatisticsBackend;
import org.evosuite.statistics.backend.HTMLStatisticsBackend;
import org.evosuite.statistics.backend.StatisticsBackend;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Listener;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchStatistics
implements Listener<ClientStateInformation> {
    private static final long serialVersionUID = -1859683466333302151L;
    private static Map<String, SearchStatistics> instances = new LinkedHashMap<String, SearchStatistics>();
    private static final Logger logger = LoggerFactory.getLogger(SearchStatistics.class);
    private TestSuiteChromosome bestIndividual = null;
    private StatisticsBackend backend = null;
    private Map<String, OutputVariable<?>> outputVariables = new TreeMap();
    private Map<String, ChromosomeOutputVariableFactory<?>> variableFactories = new TreeMap();
    private Map<String, SequenceOutputVariableFactory<?>> sequenceOutputVariableFactories = new TreeMap();
    private ClientState currentState = ClientState.INITIALIZATION;
    private long currentStateStarted = System.currentTimeMillis();
    private long searchStartTime = 0L;
    private long startTime = System.currentTimeMillis();
    private List<List<TestGenerationResult>> results = new ArrayList<List<TestGenerationResult>>();

    private SearchStatistics() {
        switch (Properties.STATISTICS_BACKEND) {
            case CONSOLE: {
                this.backend = new ConsoleStatisticsBackend();
                break;
            }
            case CSV: {
                this.backend = new CSVStatisticsBackend();
                break;
            }
            case HTML: {
                this.backend = new HTMLStatisticsBackend();
                break;
            }
            case DEBUG: {
                this.backend = new DebugStatisticsBackend();
                break;
            }
            default: {
                this.backend = null;
            }
        }
        this.initFactories();
        this.setOutputVariable(RuntimeVariable.Random_Seed, Randomness.getSeed());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.CoverageTimeline.name(), new CoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.FitnessTimeline.name(), new FitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.SizeTimeline.name(), new SizeSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.LengthTimeline.name(), new LengthSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.TotalExceptionsTimeline.name(), DirectSequenceOutputVariableFactory.getInteger(RuntimeVariable.TotalExceptionsTimeline));
        this.sequenceOutputVariableFactories.put(RuntimeVariable.IBranchGoalsTimeline.name(), new IBranchGoalsSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.BranchCoverageTimeline.name(), new BranchCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyBranchFitnessTimeline.name(), new OnlyBranchFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyBranchCoverageTimeline.name(), new OnlyBranchCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.CBranchFitnessTimeline.name(), new CBranchFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.CBranchCoverageTimeline.name(), new CBranchCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodTraceFitnessTimeline.name(), new MethodTraceFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodTraceCoverageTimeline.name(), new MethodTraceCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodFitnessTimeline.name(), new MethodFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodCoverageTimeline.name(), new MethodCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodNoExceptionFitnessTimeline.name(), new MethodNoExceptionFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.MethodNoExceptionCoverageTimeline.name(), new MethodNoExceptionCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.RhoScoreTimeline.name(), new RhoFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.AmbiguityScoreTimeline.name(), new AmbiguityFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.LineFitnessTimeline.name(), new LineFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.LineCoverageTimeline.name(), new LineCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OutputFitnessTimeline.name(), new OutputFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OutputCoverageTimeline.name(), new OutputCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.InputFitnessTimeline.name(), new InputFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.InputCoverageTimeline.name(), new InputCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.ExceptionFitnessTimeline.name(), new ExceptionFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.ExceptionCoverageTimeline.name(), new ExceptionCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.WeakMutationCoverageTimeline.name(), new WeakMutationCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyMutationFitnessTimeline.name(), new OnlyMutationFitnessSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.OnlyMutationCoverageTimeline.name(), new OnlyMutationCoverageSequenceOutputVariableFactory());
        this.sequenceOutputVariableFactories.put(RuntimeVariable.DiversityTimeline.name(), DirectSequenceOutputVariableFactory.getDouble(RuntimeVariable.DiversityTimeline));
        this.sequenceOutputVariableFactories.put(RuntimeVariable.DensityTimeline.name(), DirectSequenceOutputVariableFactory.getDouble(RuntimeVariable.DensityTimeline));
        this.sequenceOutputVariableFactories.put(RuntimeVariable.FeaturesFound.name(), DirectSequenceOutputVariableFactory.getInteger(RuntimeVariable.FeaturesFound));
        if (MasterServices.getInstance().getMasterNode() != null) {
            MasterServices.getInstance().getMasterNode().addListener(this);
        }
    }

    public static SearchStatistics getInstance() {
        return SearchStatistics.getInstance("Client-0");
    }

    public static SearchStatistics getInstance(String rmiClientIdentifier) {
        SearchStatistics instance = instances.get(rmiClientIdentifier);
        if (instance == null) {
            instance = new SearchStatistics();
            instances.put(rmiClientIdentifier, instance);
        }
        return instance;
    }

    public static void clearInstance() {
        SearchStatistics.clearInstance("Client-0");
    }

    public static void clearInstance(String rmiClientIdentifier) {
        instances.remove(rmiClientIdentifier);
    }

    public void currentIndividual(Chromosome<?> individual) {
        if (this.backend == null) {
            return;
        }
        if (!(individual instanceof TestSuiteChromosome)) {
            AtMostOnceLogger.warn(logger, "searchStatistics expected a TestSuiteChromosome");
            return;
        }
        logger.debug("Received individual");
        this.bestIndividual = (TestSuiteChromosome)individual;
        for (ChromosomeOutputVariableFactory<?> chromosomeOutputVariableFactory : this.variableFactories.values()) {
            this.setOutputVariable(chromosomeOutputVariableFactory.getVariable((TestSuiteChromosome)individual));
        }
        for (SequenceOutputVariableFactory sequenceOutputVariableFactory : this.sequenceOutputVariableFactories.values()) {
            sequenceOutputVariableFactory.update((TestSuiteChromosome)individual);
        }
    }

    public void setOutputVariable(RuntimeVariable variable, Object value) {
        this.setOutputVariable(new OutputVariable<Object>(variable.toString(), value));
    }

    public void setOutputVariable(OutputVariable<?> variable) {
        if (this.sequenceOutputVariableFactories.containsKey(variable.getName())) {
            DirectSequenceOutputVariableFactory v = (DirectSequenceOutputVariableFactory)this.sequenceOutputVariableFactories.get(variable.getName());
            v.setValue(variable.getValue());
        } else {
            this.outputVariables.put(variable.getName(), variable);
        }
    }

    public void addTestGenerationResult(List<TestGenerationResult> result) {
        this.results.add(result);
    }

    public List<List<TestGenerationResult>> getTestGenerationResults() {
        return this.results;
    }

    public Map<String, OutputVariable<?>> getOutputVariables() {
        return this.outputVariables;
    }

    private List<String> getAllOutputVariableNames() {
        String[] essentials = new String[]{"TARGET_CLASS", "criterion", RuntimeVariable.Coverage.toString(), RuntimeVariable.Total_Goals.toString(), RuntimeVariable.Covered_Goals.toString()};
        ArrayList<String> variableNames = new ArrayList<String>(Arrays.asList(essentials));
        return variableNames;
    }

    private Collection<String> getOutputVariableNames() {
        ArrayList<String> variableNames = new ArrayList<String>();
        if (Properties.OUTPUT_VARIABLES == null) {
            variableNames.addAll(this.getAllOutputVariableNames());
        } else {
            for (String entry : Properties.OUTPUT_VARIABLES.split(",")) {
                variableNames.add(entry.trim());
            }
        }
        return variableNames;
    }

    private Map<String, OutputVariable<?>> getOutputVariables(TestSuiteChromosome individual) {
        return this.getOutputVariables(individual, false);
    }

    private Map<String, OutputVariable<?>> getOutputVariables(TestSuiteChromosome individual, boolean skip_missing) {
        LinkedHashMap variables = new LinkedHashMap();
        for (String variableName : this.getOutputVariableNames()) {
            if (this.outputVariables.containsKey(variableName)) {
                variables.put(variableName, this.outputVariables.get(variableName));
                continue;
            }
            if (Properties.getParameters().contains(variableName)) {
                variables.put(variableName, new PropertyOutputVariableFactory(variableName).getVariable());
                continue;
            }
            if (this.variableFactories.containsKey(variableName)) {
                variables.put(variableName, this.variableFactories.get(variableName).getVariable(individual));
                continue;
            }
            if (this.sequenceOutputVariableFactories.containsKey(variableName)) {
                for (OutputVariable<?> var : this.sequenceOutputVariableFactories.get(variableName).getOutputVariables()) {
                    variables.put(var.getName(), var);
                }
                continue;
            }
            if (skip_missing) {
                variables.put(variableName, new OutputVariable<String>(variableName, ""));
                continue;
            }
            logger.error("No obtained value for output variable: " + variableName);
            return null;
        }
        return variables;
    }

    public boolean writeStatistics() {
        boolean valid;
        logger.info("Writing statistics");
        if (this.backend == null) {
            return false;
        }
        this.outputVariables.put(RuntimeVariable.Total_Time.name(), new OutputVariable<Long>(RuntimeVariable.Total_Time.name(), System.currentTimeMillis() - this.startTime));
        if (this.bestIndividual == null) {
            logger.error("No statistics has been saved because EvoSuite failed to generate any test case");
            return false;
        }
        TestSuiteChromosome individual = this.bestIndividual;
        Map<String, OutputVariable<?>> map = this.getOutputVariables(individual);
        if (map == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean couldBeFine = MasterServices.getInstance().getMasterNode().getCurrentState().stream().anyMatch(s -> s.equals((Object)ClientState.DONE) || s.equals((Object)ClientState.FINISHED));
            if (couldBeFine) {
                for (int counter = 0; map == null && counter < 5; ++counter) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    map = this.getOutputVariables(individual);
                }
            }
            if (map == null && Properties.IGNORE_MISSING_STATISTICS) {
                map = this.getOutputVariables(individual, true);
            }
            if (map == null) {
                logger.error("Not going to write down statistics data, as some are missing");
                return false;
            }
        }
        if (!(valid = RuntimeVariable.validateRuntimeVariables(map))) {
            logger.error("Not going to write down statistics data, as some data is invalid");
            return false;
        }
        this.backend.writeData(individual, map);
        return true;
    }

    public boolean writeStatisticsForAnalysis() {
        logger.info("Writing statistics");
        if (this.backend == null) {
            LoggingUtils.getEvoLogger().info("Backend is null");
            return false;
        }
        this.outputVariables.put(RuntimeVariable.Total_Time.name(), new OutputVariable<Long>(RuntimeVariable.Total_Time.name(), System.currentTimeMillis() - this.startTime));
        TestSuiteChromosome individual = new TestSuiteChromosome();
        Map<String, OutputVariable<?>> map = this.getOutputVariables(individual);
        if (map == null) {
            logger.error("Not going to write down statistics data, as some are missing");
            return false;
        }
        boolean valid = RuntimeVariable.validateRuntimeVariables(map);
        if (!valid) {
            logger.error("Not going to write down statistics data, as some data is invalid");
            return false;
        }
        this.backend.writeData(individual, map);
        return true;
    }

    @Override
    public void receiveEvent(ClientStateInformation information) {
        if (information.getState() != this.currentState) {
            logger.info("Received status update: " + information);
            if (information.getState() == ClientState.SEARCH) {
                this.searchStartTime = System.currentTimeMillis();
                for (SequenceOutputVariableFactory<?> factory : this.sequenceOutputVariableFactories.values()) {
                    factory.setStartTime(this.searchStartTime);
                }
            }
            OutputVariable<Long> time = new OutputVariable<Long>("Time_" + this.currentState.getName(), System.currentTimeMillis() - this.currentStateStarted);
            this.outputVariables.put(time.getName(), time);
            this.currentState = information.getState();
            this.currentStateStarted = System.currentTimeMillis();
        }
    }

    private void initFactories() {
        this.variableFactories.put(RuntimeVariable.Length.name(), new ChromosomeLengthOutputVariableFactory());
        this.variableFactories.put(RuntimeVariable.Size.name(), new ChromosomeSizeOutputVariableFactory());
        this.variableFactories.put(RuntimeVariable.Coverage.name(), new ChromosomeCoverageOutputVariableFactory());
        this.variableFactories.put(RuntimeVariable.Fitness.name(), new ChromosomeFitnessOutputVariableFactory());
    }

    private static class OnlyMutationCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyMutationCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyMutationCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(OnlyMutationSuiteFitness.class);
        }
    }

    private static class OnlyMutationFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyMutationFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyMutationFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(OnlyMutationSuiteFitness.class);
        }
    }

    private static class WeakMutationCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public WeakMutationCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.WeakMutationCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(WeakMutationSuiteFitness.class);
        }
    }

    private static class ExceptionCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public ExceptionCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.ExceptionCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(ExceptionCoverageSuiteFitness.class);
        }
    }

    private static class ExceptionFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public ExceptionFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.ExceptionFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(ExceptionCoverageSuiteFitness.class);
        }
    }

    private static class InputCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public InputCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.InputCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(InputCoverageSuiteFitness.class);
        }
    }

    private static class InputFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public InputFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.InputFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(InputCoverageSuiteFitness.class);
        }
    }

    private static class OutputCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OutputCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.OutputCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(OutputCoverageSuiteFitness.class);
        }
    }

    private static class OutputFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OutputFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.OutputFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(OutputCoverageSuiteFitness.class);
        }
    }

    private static class LineCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public LineCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.LineCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(LineCoverageSuiteFitness.class);
        }
    }

    private static class LineFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public LineFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.LineFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(LineCoverageSuiteFitness.class);
        }
    }

    private static class AmbiguityFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public AmbiguityFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.AmbiguityScoreTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(AmbiguityCoverageSuiteFitness.class);
        }
    }

    private static class RhoFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public RhoFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.RhoScoreTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            Double d = individual.getFitnessInstanceOf(RhoCoverageSuiteFitness.class);
            return d > 1.0 ? 0.0 : d;
        }
    }

    private static class MethodNoExceptionCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodNoExceptionCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodNoExceptionCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(MethodNoExceptionCoverageSuiteFitness.class);
        }
    }

    private static class MethodNoExceptionFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodNoExceptionFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodNoExceptionFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(MethodNoExceptionCoverageSuiteFitness.class);
        }
    }

    private static class MethodCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(MethodCoverageSuiteFitness.class);
        }
    }

    private static class MethodFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(MethodCoverageSuiteFitness.class);
        }
    }

    private static class MethodTraceCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodTraceCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodTraceCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(MethodTraceCoverageSuiteFitness.class);
        }
    }

    private static class MethodTraceFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public MethodTraceFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.MethodTraceFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(MethodTraceCoverageSuiteFitness.class);
        }
    }

    private static class CBranchCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public CBranchCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.CBranchCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(CBranchSuiteFitness.class);
        }
    }

    private static class CBranchFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public CBranchFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.CBranchFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(CBranchSuiteFitness.class);
        }
    }

    private static class OnlyBranchCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyBranchCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyBranchCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(OnlyBranchCoverageSuiteFitness.class);
        }
    }

    private static class OnlyBranchFitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public OnlyBranchFitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.OnlyBranchFitnessTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getFitnessInstanceOf(OnlyBranchCoverageSuiteFitness.class);
        }
    }

    private static class BranchCoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public BranchCoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.BranchCoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverageInstanceOf(BranchCoverageSuiteFitness.class);
        }
    }

    private static class IBranchGoalsSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Integer> {
        public IBranchGoalsSequenceOutputVariableFactory() {
            super(RuntimeVariable.IBranchGoalsTimeline);
        }

        @Override
        public Integer getValue(TestSuiteChromosome individual) {
            return individual.getNumOfNotCoveredGoals();
        }
    }

    private static class LengthSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Integer> {
        public LengthSequenceOutputVariableFactory() {
            super(RuntimeVariable.LengthTimeline);
        }

        @Override
        public Integer getValue(TestSuiteChromosome individual) {
            return individual.totalLengthOfTestCases();
        }
    }

    private static class SizeSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Integer> {
        public SizeSequenceOutputVariableFactory() {
            super(RuntimeVariable.SizeTimeline);
        }

        @Override
        public Integer getValue(TestSuiteChromosome individual) {
            return individual.size();
        }
    }

    private static class CoverageSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public CoverageSequenceOutputVariableFactory() {
            super(RuntimeVariable.CoverageTimeline);
        }

        @Override
        public Double getValue(TestSuiteChromosome individual) {
            return individual.getCoverage();
        }
    }

    private static class FitnessSequenceOutputVariableFactory
    extends SequenceOutputVariableFactory<Double> {
        public FitnessSequenceOutputVariableFactory() {
            super(RuntimeVariable.FitnessTimeline);
        }

        @Override
        protected Double getValue(TestSuiteChromosome individual) {
            return individual.getFitness();
        }
    }

    private static class ChromosomeCoverageOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Double> {
        public ChromosomeCoverageOutputVariableFactory() {
            super(RuntimeVariable.Coverage);
        }

        @Override
        protected Double getData(TestSuiteChromosome individual) {
            return individual.getCoverage();
        }
    }

    private static class ChromosomeFitnessOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Double> {
        public ChromosomeFitnessOutputVariableFactory() {
            super(RuntimeVariable.Fitness);
        }

        @Override
        protected Double getData(TestSuiteChromosome individual) {
            return individual.getFitness();
        }
    }

    private static class ChromosomeSizeOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Integer> {
        public ChromosomeSizeOutputVariableFactory() {
            super(RuntimeVariable.Size);
        }

        @Override
        protected Integer getData(TestSuiteChromosome individual) {
            return individual.size();
        }
    }

    private static class ChromosomeLengthOutputVariableFactory
    extends ChromosomeOutputVariableFactory<Integer> {
        public ChromosomeLengthOutputVariableFactory() {
            super(RuntimeVariable.Length);
        }

        @Override
        protected Integer getData(TestSuiteChromosome individual) {
            return individual.totalLengthOfTestCases();
        }
    }
}

