/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.statistics;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.evosuite.Properties;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTestsStoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.StatisticsSender;
import org.evosuite.testsuite.TestSuiteChromosome;

public class StatisticsListener<T extends Chromosome<T>>
implements SearchListener<T> {
    private static final long serialVersionUID = -8229756367168023616L;
    private final BlockingQueue<T> individuals;
    private volatile boolean done;
    private volatile double bestFitness;
    private volatile boolean minimizing;
    private int numFitnessEvaluations;
    private volatile Thread notifier;
    private volatile long timeFromLastGenerationUpdate = 0L;

    public StatisticsListener() {
        this.individuals = new LinkedBlockingQueue<T>();
        this.done = false;
        this.bestFitness = Double.MAX_VALUE;
        this.minimizing = true;
        this.numFitnessEvaluations = 0;
        this.notifier = new Thread(() -> {
            while (!this.done || !this.individuals.isEmpty()) {
                try {
                    Chromosome individual = (Chromosome)this.individuals.take();
                    StatisticsSender.sendIndividualToMaster(individual);
                }
                catch (InterruptedException e) {
                    this.done = true;
                }
            }
        });
        Sandbox.addPrivilegedThread(this.notifier);
        this.notifier.start();
    }

    public StatisticsListener(StatisticsListener<T> that) {
        this.individuals = new LinkedBlockingQueue<T>(that.individuals);
        this.bestFitness = that.bestFitness;
        this.done = that.done;
        this.minimizing = that.minimizing;
        this.numFitnessEvaluations = that.numFitnessEvaluations;
        this.timeFromLastGenerationUpdate = that.timeFromLastGenerationUpdate;
        this.notifier = new Thread(that.notifier);
        Sandbox.addPrivilegedThread(this.notifier);
        this.notifier.start();
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
        long elapsed = System.currentTimeMillis() - this.timeFromLastGenerationUpdate;
        if (elapsed > Properties.TIMELINE_INTERVAL) {
            this.timeFromLastGenerationUpdate = System.currentTimeMillis();
            this.individuals.offer(algorithm.getBestIndividual());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.TotalExceptionsTimeline, ExceptionCoverageSuiteFitness.getMaxExceptionsCovered());
        }
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
        this.individuals.offer(algorithm.getBestIndividual());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Statements_Executed, MaxStatementsStoppingCondition.getNumExecutedStatements());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Tests_Executed, MaxTestsStoppingCondition.getNumExecutedTests());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Generations, algorithm.getAge());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Fitness_Evaluations, this.numFitnessEvaluations);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.TotalExceptionsTimeline, ExceptionCoverageSuiteFitness.getMaxExceptionsCovered());
        if (algorithm.getBestIndividual() instanceof TestSuiteChromosome) {
            this.reportTestSuiteResult((TestSuiteChromosome)algorithm.getBestIndividual());
        }
        this.done = true;
        try {
            this.notifier.join(3000L);
        }
        catch (InterruptedException e) {
            this.notifier.interrupt();
            Thread.currentThread().interrupt();
        }
    }

    private void reportTestSuiteResult(TestSuiteChromosome testSuite) {
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
        this.done = false;
        if (algorithm.getFitnessFunction().isMaximizationFunction()) {
            this.bestFitness = 0.0;
            this.minimizing = false;
        } else {
            this.bestFitness = Double.MAX_VALUE;
            this.minimizing = true;
        }
    }

    @Override
    public void fitnessEvaluation(T individual) {
        ++this.numFitnessEvaluations;
        if (!(individual instanceof TestSuiteChromosome)) {
            return;
        }
        double fitness = ((Chromosome)individual).getFitness();
        if (this.minimizing) {
            if (fitness < this.bestFitness) {
                this.bestFitness = fitness;
                this.individuals.offer(individual);
            }
        } else if (fitness > this.bestFitness) {
            this.bestFitness = fitness;
            this.individuals.offer(individual);
        }
    }

    @Override
    public void modification(T individual) {
    }
}

