/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ShutdownTestWriter;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.strategy.PropertiesTestGAFactory;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.testsuite.TestSuiteMinimizer;
import org.evosuite.testsuite.factories.FixedSizeTestSuiteChromosomeFactory;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndividualTestStrategy
extends TestGenerationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(IndividualTestStrategy.class);

    /*
     * Could not resolve type clashes
     */
    @Override
    public TestSuiteChromosome generateTests() {
        int total_goals;
        Properties.TEST_ARCHIVE = false;
        LoggingUtils.getEvoLogger().info("* Setting up search algorithm for individual test generation");
        ExecutionTracer.enableTraceCalls();
        PropertiesTestGAFactory factory = new PropertiesTestGAFactory();
        List<TestSuiteFitnessFunction> fitnessFunctions = this.getFitnessFunctions();
        long start_time = System.currentTimeMillis() / 1000L;
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = IndividualTestStrategy.getFitnessFactories();
        ArrayList<? extends TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
        for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
            goals.addAll(goalFactory.getCoverageGoals());
            LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
        }
        if (!this.canGenerateTestsForSUT()) {
            LoggingUtils.getEvoLogger().info("* Found no testable methods in the target class " + Properties.TARGET_CLASS);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
            return new TestSuiteChromosome();
        }
        if (Properties.SHUFFLE_GOALS) {
            Randomness.shuffle(goals);
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        LoggingUtils.getEvoLogger().info("* Total number of test goals: " + goals.size());
        ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
        StoppingCondition<TestSuiteChromosome> stoppingCondition = this.getStoppingCondition();
        TestSuiteChromosome suite = this.bootstrapRandomSuite(fitnessFunctions.get(0), goalFactories.get(0));
        HashSet<Integer> covered = new HashSet<Integer>();
        int covered_goals = 0;
        int num = 0;
        for (TestFitnessFunction fitness_function : goals) {
            if (fitness_function.isCoveredBy(suite)) {
                covered.add(num);
                ++covered_goals;
            }
            ++num;
        }
        if (covered_goals > 0) {
            LoggingUtils.getEvoLogger().info("* Random bootstrapping covered " + covered_goals + " test goals");
        }
        if (covered_goals == (total_goals = goals.size())) {
            this.zeroFitness.setFinished();
        }
        int current_budget = 0;
        long total_budget = Properties.SEARCH_BUDGET;
        LoggingUtils.getEvoLogger().info("* Budget: " + NumberFormat.getIntegerInstance().format(total_budget));
        block2: while ((long)current_budget < total_budget && covered_goals < total_goals && !this.globalTime.isFinished() && !ShutdownTestWriter.isInterrupted()) {
            long budget = (total_budget - (long)current_budget) / (long)(total_goals - covered_goals);
            logger.info("Budget: " + budget + "/" + (total_budget - (long)current_budget));
            logger.info("Statements: " + current_budget + "/" + total_budget);
            logger.info("Goals covered: " + covered_goals + "/" + total_goals);
            stoppingCondition.setLimit(budget);
            num = 0;
            for (TestFitnessFunction fitnessFunction : goals) {
                if (covered.contains(num)) {
                    ++num;
                    continue;
                }
                GeneticAlgorithm<TestChromosome> ga = factory.getSearchAlgorithm();
                if (Properties.PRINT_CURRENT_GOALS) {
                    LoggingUtils.getEvoLogger().info("* Searching for goal " + num + ": " + fitnessFunction.toString());
                }
                logger.info("Goal " + num + "/" + (total_goals - covered_goals) + ": " + fitnessFunction);
                if (ShutdownTestWriter.isInterrupted()) {
                    ++num;
                    continue;
                }
                if (this.globalTime.isFinished()) {
                    LoggingUtils.getEvoLogger().info("Skipping goal because time is up");
                    ++num;
                    continue;
                }
                ga.addFitnessFunction(fitnessFunction);
                logger.info("Starting evolution for goal " + fitnessFunction);
                ga.generateSolution();
                if (ga.getBestIndividual().getFitness() == 0.0) {
                    if (Properties.PRINT_COVERED_GOALS) {
                        LoggingUtils.getEvoLogger().info("* Covered!");
                    }
                    logger.info("Found solution, adding to test suite at " + MaxStatementsStoppingCondition.getNumExecutedStatements());
                    TestChromosome best = ga.getBestIndividual();
                    best.getTestCase().addCoveredGoal(fitnessFunction);
                    suite.addTest(best);
                    for (Object fitness_function : fitnessFunctions) {
                        ((FitnessFunction)fitness_function).getFitness(suite);
                    }
                    ++covered_goals;
                    covered.add(num);
                    if (Properties.SKIP_COVERED) {
                        Object fitness_function;
                        Set<Integer> additional_covered_nums = this.getAdditionallyCoveredGoals(goals, covered, best);
                        fitness_function = additional_covered_nums.iterator();
                        while (fitness_function.hasNext()) {
                            Integer covered_num = (Integer)fitness_function.next();
                            ++covered_goals;
                            covered.add(covered_num);
                        }
                    }
                } else {
                    logger.info("Found no solution for " + fitnessFunction + " at " + MaxStatementsStoppingCondition.getNumExecutedStatements());
                }
                current_budget = Properties.REUSE_BUDGET ? (int)((long)current_budget + stoppingCondition.getCurrentValue()) : (int)((long)current_budget + (budget + 1L));
                if (Properties.SHOW_PROGRESS && !Properties.PRINT_COVERED_GOALS && !Properties.PRINT_CURRENT_GOALS) {
                    double percent = current_budget;
                    percent = percent / (double)total_budget * 100.0;
                    double coverage = covered_goals;
                    coverage = coverage / (double)total_goals * 100.0;
                }
                if ((long)current_budget > total_budget) continue block2;
                ++num;
            }
        }
        if (Properties.SHOW_PROGRESS) {
            LoggingUtils.getEvoLogger().info("");
        }
        if (this.globalTime.isFinished()) {
            LoggingUtils.getEvoLogger().info("! Timeout reached");
        }
        if ((long)current_budget >= total_budget) {
            LoggingUtils.getEvoLogger().info("! Budget exceeded");
        } else {
            LoggingUtils.getEvoLogger().info("* Remaining budget: " + (total_budget - (long)current_budget));
        }
        int c = 0;
        int uncovered_goals = total_goals - covered_goals;
        if (uncovered_goals < 10) {
            for (TestFitnessFunction goal : goals) {
                if (!covered.contains(c)) {
                    LoggingUtils.getEvoLogger().info("! Unable to cover goal " + c + " " + goal.toString());
                }
                ++c;
            }
        } else {
            LoggingUtils.getEvoLogger().info("! #Goals that were not covered: " + uncovered_goals);
        }
        long end_time = System.currentTimeMillis() / 1000L;
        LoggingUtils.getEvoLogger().info("* Search finished after " + (end_time - start_time) + "s, " + current_budget + " statements, best individual has fitness " + suite.getFitness());
        this.sendExecutionStatistics();
        LoggingUtils.getEvoLogger().info("* Covered " + covered_goals + "/" + goals.size() + " goals");
        logger.info("Resulting test suite: " + suite.size() + " tests, length " + suite.totalLengthOfTestCases());
        return suite;
    }

    private Set<Integer> getAdditionallyCoveredGoals(List<? extends TestFitnessFunction> goals, Set<Integer> covered, TestChromosome best) {
        HashSet<Integer> r = new HashSet<Integer>();
        ExecutionResult result = best.getLastExecutionResult();
        assert (result != null);
        int num = -1;
        for (TestFitnessFunction testFitnessFunction : goals) {
            if (covered.contains(++num) || !testFitnessFunction.isCovered(best, result)) continue;
            r.add(num);
            if (!Properties.PRINT_COVERED_GOALS) continue;
            LoggingUtils.getEvoLogger().info("* Additionally covered: " + testFitnessFunction.toString());
        }
        return r;
    }

    private TestSuiteChromosome bootstrapRandomSuite(FitnessFunction<?> fitness, TestFitnessFactory<?> goals) {
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS)) {
            LoggingUtils.getEvoLogger().info("* Disabled random bootstraping for dataflow criterion");
            Properties.RANDOM_TESTS = 0;
        }
        if (Properties.RANDOM_TESTS > 0) {
            LoggingUtils.getEvoLogger().info("* Bootstrapping initial random test suite");
        }
        FixedSizeTestSuiteChromosomeFactory factory = new FixedSizeTestSuiteChromosomeFactory(Properties.RANDOM_TESTS);
        TestSuiteChromosome suite = factory.getChromosome();
        if (Properties.RANDOM_TESTS > 0) {
            TestSuiteMinimizer minimizer = new TestSuiteMinimizer(goals);
            minimizer.minimize(suite, true);
            LoggingUtils.getEvoLogger().info("* Initial test suite contains " + suite.size() + " tests");
        }
        return suite;
    }
}

