/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.ClientProcess;
import org.evosuite.Properties;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.TestSuiteChromosomeFactoryMock;
import org.evosuite.ga.TestSuiteFitnessFunctionMock;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.strategy.PropertiesSuiteGAFactory;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.factories.RandomLengthTestFactory;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;

public class MOSuiteStrategy
extends TestGenerationStrategy {
    @Override
    public TestSuiteChromosome generateTests() {
        if (Properties.ALGORITHM == Properties.Algorithm.LIPS) {
            Properties.TEST_ARCHIVE = false;
        }
        PropertiesSuiteGAFactory algorithmFactory = new PropertiesSuiteGAFactory();
        GeneticAlgorithm<TestSuiteChromosome> algorithm = algorithmFactory.getSearchAlgorithm();
        TestSuiteChromosomeFactoryMock factory = new TestSuiteChromosomeFactoryMock(new RandomLengthTestFactory());
        algorithm.setChromosomeFactory(factory);
        if (Properties.SERIALIZE_GA || Properties.CLIENT_ON_THREAD) {
            TestGenerationResultBuilder.getInstance().setGeneticAlgorithm(algorithm);
        }
        long startTime = System.currentTimeMillis() / 1000L;
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = MOSuiteStrategy.getFitnessFactories();
        ArrayList<TestSuiteFitnessFunctionMock> fitnessFunctions = new ArrayList<TestSuiteFitnessFunctionMock>();
        for (TestFitnessFactory<? extends TestFitnessFunction> testFitnessFactory : goalFactories) {
            for (TestFitnessFunction testFitnessFunction : testFitnessFactory.getCoverageGoals()) {
                TestSuiteFitnessFunctionMock mock = new TestSuiteFitnessFunctionMock(testFitnessFunction);
                fitnessFunctions.add(mock);
            }
        }
        algorithm.addFitnessFunctions(fitnessFunctions);
        algorithm.addListener(this.progressMonitor);
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Total number of test goals for {}: {}", (Object)Properties.ALGORITHM.name(), (Object)fitnessFunctions.size());
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STATEMENT) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.RHO) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.BRANCH) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.AMBIGUITY)) {
            ExecutionTracer.enableTraceCalls();
        }
        algorithm.resetStoppingConditions();
        TestSuiteChromosome testSuite = null;
        if (!Properties.STOP_ZERO || !fitnessFunctions.isEmpty() || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.EXCEPTION)) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Using seed {}", (Object)Randomness.getSeed());
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Starting evolution");
            ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
            algorithm.generateSolution();
            testSuite = algorithm.getBestIndividual();
            if (testSuite.getTestChromosomes().isEmpty()) {
                LoggingUtils.getEvoLogger().warn(ClientProcess.getPrettyPrintIdentifier() + "Could not generate any test case");
            }
        } else {
            this.zeroFitness.setFinished();
            testSuite = new TestSuiteChromosome();
            for (FitnessFunction fitnessFunction : testSuite.getFitnessValues().keySet()) {
                testSuite.setCoverage(fitnessFunction, 1.0);
            }
        }
        long l = System.currentTimeMillis() / 1000L;
        if (Properties.SHOW_PROGRESS) {
            LoggingUtils.getEvoLogger().info("");
        }
        String string = " statements, best individual has fitness: ";
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Search finished after " + (l - startTime) + "s and " + algorithm.getAge() + " generations, " + MaxStatementsStoppingCondition.getNumExecutedStatements() + string + testSuite.getFitness());
        this.sendExecutionStatistics();
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, algorithm.getFitnessFunctions().size());
        return testSuite;
    }
}

