/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.metaheuristics.NoveltySearch;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.novelty.BranchNoveltyFunction;
import org.evosuite.novelty.SuiteFitnessEvaluationListener;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.strategy.PropertiesNoveltySearchFactory;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoveltyStrategy
extends TestGenerationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(NoveltyStrategy.class);

    @Override
    public TestSuiteChromosome generateTests() {
        LoggingUtils.getEvoLogger().info("* Setting up search algorithm for novelty search");
        PropertiesNoveltySearchFactory algorithmFactory = new PropertiesNoveltySearchFactory();
        NoveltySearch algorithm = algorithmFactory.getSearchAlgorithm();
        if (Properties.SERIALIZE_GA || Properties.CLIENT_ON_THREAD) {
            TestGenerationResultBuilder.getInstance().setGeneticAlgorithm(algorithm);
        }
        long startTime = System.currentTimeMillis() / 1000L;
        List<TestSuiteFitnessFunction> fitnessFunctions = this.getFitnessFunctions();
        SuiteFitnessEvaluationListener listener = new SuiteFitnessEvaluationListener(fitnessFunctions);
        algorithm.addListener(listener);
        algorithm.setNoveltyFunction(new BranchNoveltyFunction());
        if (Properties.TRACK_DIVERSITY) {
            throw new RuntimeException("Tracking population diversity is not supported by novelty search");
        }
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STATEMENT) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.RHO) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.AMBIGUITY)) {
            ExecutionTracer.enableTraceCalls();
        }
        algorithm.resetStoppingConditions();
        List<TestFitnessFunction> goals = this.getGoals(true);
        if (!this.canGenerateTestsForSUT()) {
            LoggingUtils.getEvoLogger().info("* Found no testable methods in the target class " + Properties.TARGET_CLASS);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
            return new TestSuiteChromosome();
        }
        TestSuiteChromosome testSuite = null;
        if (!Properties.STOP_ZERO || !goals.isEmpty() || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.EXCEPTION)) {
            LoggingUtils.getEvoLogger().info("* Using seed {}", (Object)Randomness.getSeed());
            LoggingUtils.getEvoLogger().info("* Starting evolution");
            ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
            algorithm.generateSolution();
            testSuite = Archive.getArchiveInstance().mergeArchiveAndSolution(new TestSuiteChromosome());
        } else {
            this.zeroFitness.setFinished();
            testSuite = new TestSuiteChromosome();
            for (FitnessFunction fitnessFunction : fitnessFunctions) {
                testSuite.setCoverage(fitnessFunction, 1.0);
            }
        }
        long endTime = System.currentTimeMillis() / 1000L;
        goals = this.getGoals(false);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        if (Properties.SHOW_PROGRESS) {
            LoggingUtils.getEvoLogger().info("");
        }
        if (!Properties.IS_RUNNING_A_SYSTEM_TEST) {
            LoggingUtils.getEvoLogger().info("* Search finished after " + (endTime - startTime) + "s and " + algorithm.getAge() + " generations, " + MaxStatementsStoppingCondition.getNumExecutedStatements() + " statements, best individual has fitness: " + testSuite.getFitness());
        }
        this.sendExecutionStatistics();
        return testSuite;
    }

    private List<TestFitnessFunction> getGoals(boolean verbose) {
        ArrayList<TestFitnessFunction> goals;
        block5: {
            List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories;
            block4: {
                goalFactories = NoveltyStrategy.getFitnessFactories();
                goals = new ArrayList<TestFitnessFunction>();
                if (goalFactories.size() != 1) break block4;
                TestFitnessFactory<? extends TestFitnessFunction> factory = goalFactories.iterator().next();
                goals.addAll(factory.getCoverageGoals());
                if (!verbose) break block5;
                LoggingUtils.getEvoLogger().info("* Total number of test goals: {}", (Object)factory.getCoverageGoals().size());
                if (!Properties.PRINT_GOALS) break block5;
                for (TestFitnessFunction testFitnessFunction : factory.getCoverageGoals()) {
                    LoggingUtils.getEvoLogger().info("" + testFitnessFunction.toString());
                }
                break block5;
            }
            if (verbose) {
                LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
            }
            for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
                goals.addAll(goalFactory.getCoverageGoals());
                if (!verbose) continue;
                LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
                if (!Properties.PRINT_GOALS) continue;
                for (TestFitnessFunction testFitnessFunction : goalFactory.getCoverageGoals()) {
                    LoggingUtils.getEvoLogger().info("" + testFitnessFunction.toString());
                }
            }
        }
        return goals;
    }
}

