/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.strategy;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.ArchiveTestChromosomeFactory;
import org.evosuite.ga.stoppingconditions.MaxTestsStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.StatisticsSender;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.factories.AllMethodsTestChromosomeFactory;
import org.evosuite.testcase.factories.JUnitTestCarvedChromosomeFactory;
import org.evosuite.testcase.factories.RandomLengthTestFactory;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomTestStrategy
extends TestGenerationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(RandomTestStrategy.class);

    @Override
    public TestSuiteChromosome generateTests() {
        LoggingUtils.getEvoLogger().info("* Using random test generation");
        List<TestSuiteFitnessFunction> fitnessFunctions = this.getFitnessFunctions();
        TestSuiteChromosome suite = new TestSuiteChromosome();
        for (TestSuiteFitnessFunction fitnessFunction : fitnessFunctions) {
            suite.addFitness(fitnessFunction);
        }
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = RandomTestStrategy.getFitnessFactories();
        ArrayList<? extends TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
        for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
            goals.addAll(goalFactory.getCoverageGoals());
            LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        if (!this.canGenerateTestsForSUT()) {
            LoggingUtils.getEvoLogger().info("* Found no testable methods in the target class " + Properties.TARGET_CLASS);
            return new TestSuiteChromosome();
        }
        ChromosomeFactory<TestChromosome> factory = this.getChromosomeFactory();
        StoppingCondition<TestSuiteChromosome> stoppingCondition = this.getStoppingCondition();
        for (FitnessFunction fitnessFunction : fitnessFunctions) {
            fitnessFunction.getFitness(suite);
        }
        ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
        int number_generations = 0;
        while (!this.isFinished(suite, stoppingCondition)) {
            ++number_generations;
            TestChromosome testChromosome = factory.getChromosome();
            TestSuiteChromosome clone = suite.clone();
            clone.addTest(testChromosome);
            for (FitnessFunction fitnessFunction : fitnessFunctions) {
                fitnessFunction.getFitness(clone);
                logger.debug("Old fitness: {}, new fitness: {}", (Object)suite.getFitness(), (Object)clone.getFitness());
            }
            if (clone.compareTo(suite) >= 0) continue;
            suite = clone;
            StatisticsSender.executedAndThenSendIndividualToMaster(clone);
        }
        LoggingUtils.getEvoLogger().info("* Search Budget:");
        LoggingUtils.getEvoLogger().info("\t- " + stoppingCondition.toString());
        this.sendExecutionStatistics();
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Fitness_Evaluations, MaxTestsStoppingCondition.getNumExecutedTests());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Generations, number_generations);
        return suite;
    }

    protected ChromosomeFactory<TestChromosome> getChromosomeFactory() {
        switch (Properties.TEST_FACTORY) {
            case ALLMETHODS: {
                return new AllMethodsTestChromosomeFactory();
            }
            case RANDOM: {
                return new RandomLengthTestFactory();
            }
            case ARCHIVE: {
                return new ArchiveTestChromosomeFactory();
            }
            case JUNIT: {
                return new JUnitTestCarvedChromosomeFactory(new RandomLengthTestFactory());
            }
        }
        throw new RuntimeException("Unsupported test factory: " + (Object)((Object)Properties.TEST_FACTORY));
    }
}

