/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.symbolic.DSEAlgorithm;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;

public class DSEStrategy
extends TestGenerationStrategy {
    @Override
    public TestSuiteChromosome generateTests() {
        LoggingUtils.getEvoLogger().info("* Setting up DSE test suite generation");
        long startTime = System.currentTimeMillis() / 1000L;
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.BRANCH};
        List<TestSuiteFitnessFunction> fitnessFunctions = this.getFitnessFunctions();
        List<TestFitnessFunction> goals = this.getGoals(true);
        if (!this.canGenerateTestsForSUT()) {
            LoggingUtils.getEvoLogger().info("* Found no testable methods in the target class " + Properties.TARGET_CLASS);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
            return new TestSuiteChromosome();
        }
        TestSuiteChromosome testSuite = null;
        if (!Properties.STOP_ZERO || !goals.isEmpty() || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.EXCEPTION)) {
            LoggingUtils.getEvoLogger().info("* Using seed {}", (Object)Randomness.getSeed());
            LoggingUtils.getEvoLogger().info("* Starting evolution");
            ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
            DSEAlgorithm algorithm = new DSEAlgorithm();
            StoppingCondition<TestSuiteChromosome> stoppingCondition = this.getStoppingCondition();
            algorithm.addFitnessFunctions(fitnessFunctions);
            if (Properties.STOP_ZERO) {
                // empty if block
            }
            algorithm.setStoppingCondition(stoppingCondition);
            algorithm.generateSolution();
            testSuite = (TestSuiteChromosome)algorithm.getBestIndividual();
            if (Properties.SERIALIZE_GA || Properties.CLIENT_ON_THREAD) {
                TestGenerationResultBuilder.getInstance().setGeneticAlgorithm(algorithm);
            }
        } else {
            this.zeroFitness.setFinished();
            testSuite = new TestSuiteChromosome();
            for (FitnessFunction fitnessFunction : fitnessFunctions) {
                testSuite.setCoverage(fitnessFunction, 1.0);
            }
        }
        long endTime = System.currentTimeMillis() / 1000L;
        goals = this.getGoals(false);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        if (Properties.SHOW_PROGRESS) {
            LoggingUtils.getEvoLogger().info("");
        }
        if (!Properties.IS_RUNNING_A_SYSTEM_TEST) {
            LoggingUtils.getEvoLogger().info("* Search finished after " + (endTime - startTime) + "s and " + MaxStatementsStoppingCondition.getNumExecutedStatements() + " statements, best individual has fitness: " + testSuite.getFitness());
        }
        this.sendExecutionStatistics();
        return testSuite;
    }

    private List<TestFitnessFunction> getGoals(boolean verbose) {
        ArrayList<TestFitnessFunction> goals;
        block5: {
            List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories;
            block4: {
                goalFactories = DSEStrategy.getFitnessFactories();
                goals = new ArrayList<TestFitnessFunction>();
                if (goalFactories.size() != 1) break block4;
                TestFitnessFactory<? extends TestFitnessFunction> factory = goalFactories.iterator().next();
                goals.addAll(factory.getCoverageGoals());
                if (!verbose) break block5;
                LoggingUtils.getEvoLogger().info("* Total number of test goals: {}", (Object)factory.getCoverageGoals().size());
                if (!Properties.PRINT_GOALS) break block5;
                for (TestFitnessFunction testFitnessFunction : factory.getCoverageGoals()) {
                    LoggingUtils.getEvoLogger().info("" + testFitnessFunction.toString());
                }
                break block5;
            }
            if (verbose) {
                LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
            }
            for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
                goals.addAll(goalFactory.getCoverageGoals());
                if (!verbose) continue;
                LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
                if (!Properties.PRINT_GOALS) continue;
                for (TestFitnessFunction testFitnessFunction : goalFactory.getCoverageGoals()) {
                    LoggingUtils.getEvoLogger().info("" + testFitnessFunction.toString());
                }
            }
        }
        return goals;
    }
}

