/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr;

import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.ConstraintVisitor;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringConstraint
extends Constraint<String> {
    static Logger log = LoggerFactory.getLogger(StringConstraint.class);
    private final StringComparison left;
    private final Comparator cmp;
    private final IntegerConstant right;
    private static final long serialVersionUID = -3187023627540040535L;

    public StringConstraint(StringComparison left, Comparator comp, IntegerConstant right) {
        this.left = left;
        this.cmp = comp;
        this.right = right;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.getInstance().reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Comparator getComparator() {
        return this.cmp;
    }

    @Override
    public Expression<?> getLeftOperand() {
        return this.left;
    }

    @Override
    public Expression<?> getRightOperand() {
        return this.right;
    }

    public String toString() {
        return this.left + this.cmp.toString() + this.right;
    }

    @Override
    public Constraint<String> negate() {
        return new StringConstraint(this.left, this.cmp.not(), this.right);
    }

    @Override
    public <K, V> K accept(ConstraintVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

